package WordList::EN::PersonName::PopularBabyName::US::SSA::1950::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("avg_word_len",5.708,"num_words_contain_unicode",0,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"shortest_word_len",2,"num_words_contain_nonword_chars",0,"longest_word_len",11,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"num_words",1000); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1950 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::1950::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1950 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::1950::MaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::1950::MaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::1950::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.708 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
James
Robert
John
Michael
David
William
Richard
Thomas
Charles
Gary
Larry
Ronald
Joseph
Donald
Kenneth
Steven
Dennis
Paul
Stephen
George
Daniel
Edward
Mark
Jerry
Gregory
Bruce
Roger
Douglas
Frank
Terry
Raymond
Timothy
Lawrence
Gerald
Wayne
Anthony
Peter
Patrick
Danny
Walter
Alan
Willie
Jeffrey
Carl
Harold
Arthur
Henry
Jack
Dale
Johnny
Roy
Ralph
Philip
Joe
Jimmy
Albert
Billy
Eugene
Glenn
Stanley
Harry
Samuel
Howard
Phillip
Bobby
Louis
Russell
Andrew
Craig
Randall
Allen
Christopher
Kevin
Barry
Frederick
Ronnie
Leonard
Keith
Brian
Randy
Ernest
Scott
Steve
Fred
Martin
Francis
Melvin
Rodney
Eddie
Norman
Lee
Earl
Marvin
Tommy
Clarence
Alfred
Curtis
Eric
Theodore
Clifford
Vincent
Leroy
Jerome
Micheal
Calvin
Victor
Don
Gordon
Jose
Bernard
Ray
Herbert
Mike
Jesse
Jay
Darrell
Edwin
Warren
Leon
Dean
Alvin
Gene
Benjamin
Nicholas
Glen
Leslie
Lloyd
Ricky
Dan
Joel
Bill
Juan
Lewis
Vernon
Lonnie
Clyde
Duane
Jon
Jim
Jackie
Jimmie
Allan
Floyd
Gilbert
Tom
Dwight
Harvey
Lester
Tony
Donnie
Charlie
Bradley
Franklin
Lynn
Freddie
Neil
Johnnie
Manuel
Herman
Milton
Leo
Randolph
Jonathan
Garry
Wesley
Arnold
Marc
Rick
Chester
Ted
Cecil
Karl
Matthew
Rickey
Reginald
Terrence
Claude
Chris
Guy
Kent
Mitchell
Nathaniel
Jeffery
Dana
Stuart
Maurice
Roland
Carlos
Alexander
Fredrick
Gerard
Oscar
Perry
Marshall
Sidney
Rex
Kerry
Wallace
Kirk
Ruben
Clifton
Jessie
Darryl
Bob
Daryl
Hugh
Sam
Terrance
Edgar
Antonio
Morris
Brent
Earnest
Sammy
Benny
Dave
Neal
Willard
Wendell
Clinton
Otis
Byron
Lyle
Marion
Tyrone
Elmer
Laurence
Greg
Nelson
Aaron
Ira
Kim
Kurt
Virgil
Jesus
Ross
Luther
Bennie
Rudolph
Clayton
Max
Tim
Nathan
Alex
Everett
Mario
Bryan
Robin
Lance
Ben
Horace
Luis
Frankie
Francisco
Raul
Sylvester
Loren
Troy
Alton
Sherman
Gregg
Clark
Salvatore
Geoffrey
Ricardo
Rudy
Jan
Rodger
Hubert
Roberto
Tommie
Todd
Roosevelt
Wilbert
Bradford
Lowell
Delbert
Carlton
Ramon
Pete
Leland
Isaac
Marcus
Oliver
Carroll
Archie
Edmund
Homer
Teddy
Malcolm
Jeff
Preston
Pedro
Darrel
Myron
Monte
Wade
Doyle
Kenny
Jerald
Julian
Julius
Mickey
Felix
Lanny
Wilbur
Kelly
Randal
Armando
Mack
Van
Denis
Willis
Roderick
Hector
Ivan
Grant
Jacob
Ellis
Brad
Forrest
Terence
Miguel
Cary
Angelo
Stewart
Freddy
Nick
Ervin
Grady
Dallas
Percy
Stephan
Rufus
Sheldon
Unknown
Andy
Sammie
Merle
Dewey
Owen
Rene
Pat
Conrad
Travis
Lorenzo
Buddy
Irvin
Hal
Garland
Rickie
Louie
Alonzo
Arturo
Lionel
Guadalupe
Phil
Alfonso
Wilson
Ron
Vaughn
Ken
Elbert
Fernando
Boyd
Dwayne
Monty
Bert
Salvador
Grover
Woodrow
Gale
Cleveland
Galen
Miles
Darwin
Royce
Spencer
Alfredo
Edmond
Emmett
Adam
Noel
Ernie
Wilfred
Dominic
Abraham
Rocky
Rafael
Adrian
Irving
Denny
Andre
Aubrey
Eldon
Gerry
Moses
Ronny
Winston
Marlin
Amos
Cornelius
Elijah
Ned
Ernesto
Lamar
Junior
Harlan
Carey
Linwood
Dick
Christian
Harley
Rodolfo
Barney
Orville
Vance
Gabriel
Dominick
Loyd
Burton
Sterling
Billie
Donn
Elliott
Dannie
Sanford
Norris
Alberto
Austin
Kyle
Frederic
Blaine
Lon
Angel
Murray
Roscoe
Enrique
Kermit
Javier
Jerrold
Kirby
Simon
Tracy
Will
Emanuel
Al
Brett
Harrison
Nolan
Dewayne
Norbert
Jeffry
Donny
Dudley
Alphonso
Thaddeus
Elton
Evan
Fredric
Jasper
Thurman
Emil
Reuben
Wiley
Chuck
Jason
Reed
August
Terrell
Derek
Drew
Randell
Carmen
Eddy
Colin
Dexter
Elliot
Lamont
Pablo
Jess
Julio
Michel
Odell
Jake
Levi
Bobbie
Joesph
Ramiro
Sandy
Joey
Jorge
Kennith
Doug
Elvin
Millard
Clay
Elwood
Marty
Reynaldo
Barton
Ivory
Rocco
Darnell
Tomas
Weldon
Merlin
Shawn
Charley
Gail
Harris
Derrick
Jerold
Luke
Abel
Carter
Ulysses
Ward
Armand
Garrett
Jackson
Jean
Danial
Ed
Felipe
Gus
Jeremiah
Merrill
Rogers
Elias
Emory
Ollie
Rory
Domingo
Joshua
Orlando
Sean
Kendall
Lane
Rogelio
Timmy
Cornell
Russel
Christophe
Jaime
Maynard
Noah
Riley
Andres
Dane
Otto
Curt
Johnie
Zachary
Eduardo
Roman
Toby
Delmar
Jefferson
Irwin
Booker
Stan
Blair
Donnell
Hollis
Mervin
Shelby
Gilberto
Israel
Adolph
Coy
Erwin
Reid
Vern
Eli
Kelvin
Solomon
Isaiah
Jody
Val
Reggie
Benito
Connie
Errol
Lonny
Dickie
Major
Bennett
Cedric
Duncan
Winfred
Erik
Santiago
Seth
Blake
Denver
Glynn
Ismael
Buford
Ignacio
Linda
Carol
Lenard
Emery
Justin
Bart
Bernie
Davis
Guillermo
Lavern
Clement
Carmine
Emilio
Everette
Monroe
Anton
Bryant
Bryce
Santos
Shelton
Ian
Mitchel
Mac
Laverne
Morgan
Quentin
Carson
Damon
Fletcher
Scotty
Silas
Sonny
Gearld
Mary
Stanford
Truman
Bud
Butch
Robbie
Vito
Wilford
Alejandro
Jacky
Casey
Herschel
Pierre
Stevan
Forest
Rolland
Saul
Stevie
Basil
Dwain
Earle
Freeman
Haywood
Mckinley
Wilton
Clair
Hershel
Odis
Royal
Lawerence
Geary
Hiram
Jere
Myles
Anderson
Augustine
Douglass
Stanton
Nicky
Otha
Arlen
Lindsey
Kris
Rand
Stacy
Emerson
Burt
Artis
Cleo
Emmitt
Lupe
Brady
Burl
Dalton
Garth
Rayford
Ryan
Judson
Kenton
Lindsay
Milo
Rusty
Alva
Gayle
Graham
Isiah
Theron
Benedict
Hilton
Raleigh
Buster
Carrol
Dirk
Cliff
Gaylord
Marcos
Mikel
Sergio
Gaylon
Kip
Nicolas
Wilmer
Foster
Lacy
Nickolas
Shannon
Lannie
Lyman
Reynold
Donovan
King
Mason
Alden
Coleman
Houston
Normand
Pasquale
Jerel
Marcel
Mathew
Sherwood
Adolfo
Cameron
Cruz
Jamie
Lincoln
Wardell
Columbus
Dee
Elroy
Lemuel
Williams
Felton
Humberto
Jonathon
Woody
Hank
Mose
Patricia
Randel
Wilburn
Alphonse
Milford
Taylor
Cyril
Rod
Shirley
Avery
Cletus
Delmer
Gaylen
Jules
Vicente
Arden
Cyrus
Leigh
Marco
Tyler
Claud
Dewitt
Federico
Napoleon
Newton
Olen
Sydney
Augustus
Eloy
Hayward
Lynwood
Quinton
Elmo
Fidel
Lucius
Matt
Ezra
Huey
Lorin
Erick
Howell
Lauren
Rolando
Rollin
Terrill
Bertram
Darold
Margarito
Rubin
Carlo
Del
Jeremy
Olin
Regis
Bruno
Curtiss
Gerardo
Gregorio
Hoyt
Lawrance
Lorenza
Lyndon
Barbara
Garfield
Gustavo
Issac
Melton
Arnulfo
Boyce
Emile
Fritz
Joaquin
Jordan
Verne
Waymon
Zane
Dennie
Noe
Berry
Enoch
Kit
Mel
Noble
Von
Walton
Alvis
Chad
Domenic
Dwaine
Len
Leonardo
Wally
Elvis
Hans
Lucien
Raphael
Raymon
Adan
Alfonzo
Alford
Carleton
Cleve
Courtney
Dell
Elwin
Jared
Jonas
Junius
Lesley
Nancy
Omar
Oren
Toney
Artie
Ezzard
Hermon
Isidro
Maxwell
Randle
Vince
Xavier
Delton
Farrell
Murphy
Raymundo
Winford
Art
Beverly
Brendan
Esteban
Lyn
Parker
Valentin
Carnell
Clint
Duke
Levon
Lucious
Milan
Roddy
Tod
Brooks
Hugo
Marcelino
Trinidad
Verlin
Arlie
Corey
Franklyn
Scot
Shaun
Wayman
Ashley
Benton
Brant
Dorsey
Emmanuel
Evans
Garold
Granville
Jacques
Lonzo
Maxie
Niles
Orval
Susan
Valentine
Carlyle
Darell
Denton
Edison
Eldridge
Lary
Adolphus
Alonza
Crawford
Curley
Duwayne
Efrain
Gerold
Hosea
Morton
Shelly
Stacey
Bonnie
Brandon
Ellsworth
Hardy
Hobert
Ike
Lafayette
Meredith
Porter
Rupert
Theadore
Walker
Agustin
Arlin
Cesar
Ferdinand
Gonzalo
Jed
Mcarthur
Russ
Sherwin
Stefan
Vernell
Warner
Windell
Cordell
Garnett
Gil
Harmon
Jarvis
Jory
Layne
Marlon
Prince
Reyes
Samual
Talmadge
Alec
Clarance
Merritt
Michial
Reese
Bernardo
Bryon
Danniel
Eliot
Ezell
Jame
Leonel
Omer
Ritchie
Tex
Winfield
Wyatt
Clarke
Deryl
Edwardo
Elden
Hunter
Jerrell
Lawson
Leander
Lenny
Loy
Oneal
