#!/usr/bin/perl

package eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSearchResultsExpressRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressRequestType

=head1 DESCRIPTION

<b>Please check this
<a href="https://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=928">Knowledge Base article</a>
for updates on current issues with GetSearchResultsExpress.</b><br>
<br>
Retrieves brief details about active items that are listed on eBay Express, eBay
catalog products that have been used to pre-fill data in these items, and a
histogram that shows the distribution of items and catalog products across Express
departments, aisles, and/or product types.<br>
<br>
This call only returns Express data for the site associated with the site
ID that you specify in the request URL (for the SOAP API) or the X-EBAY-API-SITEID
header (for the XML API). For example, if you specify site ID 0, then data for
Express US is returned. <br>
<br>
Currently, this call is only supported for site ID 0 (Express US).
<br>
<br>
The Sandbox does not support GetSearchResultsExpress.<br>
<br>
You can configure the call to retrieve only the item data, only the catalog
product data, only the histogram, or any combination of these results. By default,
the call returns brief summaries of each.<br>
<br>
<b>Item Results:</b> For each item returned (if any), the response
includes a brief set of details, such as the item price (including shipping). You
can retrieve more or fewer details about each item by using the ItemDetails field.
To retrieve other details about a given item, use a call like GetSellerList or
GetItem.<br>
<br>
<b>Catalog Product Results:</b> For each eBay catalog product returned
(if any), the response includes a brief set of details, such as the minimum and
maximum price of listings that have been pre-filled based on that product. You can
retrieve more or fewer details about each product by using the ProductDetails
field.<br>
<br>
<b>Histogram Results:</b> Instead of grouping items by category, the
Express search engine groups items into <i>domains</i>. A domain is a
set of items to which Express can apply a common set of search rules. Express
supports three kinds of domains: <i>Product types</i>,
<i>aisles</i>, and <i>departments</i>, like a typical
department store. (The fact that we call these "domains" is not important to
buyers and sellers, but it can be helpful to understand the domain relationships
when you are working with the API.)<br>
<br>
Listings with similar properties are classified into product type domains. For
example, "DVDs & Movies" is a product type domain. Think of a product type as
a type of good or service that can be purchased and as a leaf domain (which cannot
be the parent of other domains).<br>
<br>
<span class="tablenote"><b>Note:</b> An Express product type is
not the same as an eBay catalog product. Some Express product types are associated
with eBay catalog products, but other Express product types are not.</span>
<br>
<br>
When multiple product types share a common theme, Express groups them into an
aisle or a department. For example, the Men's Jeans product type can be grouped
with Men's Pants into a Men's Clothing aisle. When multiple aisles share a common
theme, Express groups them into departments. For example, the Men's Clothing aisle
can be grouped with a Men's Accessories aisle to form an Apparel & Accessories
department. If no groups make sense, a product type can stand alone without being
grouped. For example, "DVDs & Movies" would not be grouped with other product
types like Men's Jeans, so "DVDs & Movies" has no parent aisle or department.
(From a user's perspective, this product type is elevated to look like a
department, but in the API it is still classified as a product type.) Similarly,
an aisle can stand alone without being grouped with other aisles into a
department.<br>
<br>
See the eBay Web Services guide link below for more information about departments, aisles, and product
types. </p>
<p>
This call returns a histogram that shows the number of items and catalog products
that were found in each department, aisle, and/or product type that matches your
search criteria.<br>
<br>
The domain names and groupings are subject to change. They are determined by the
Express search engine based on the items that are currently listed on Express as
well as historical buyer behavior. This means you need to call
GetSearchResultsExpress to determine the current domain names and their
hierarchical relationships.<br>
<br>
<span class="tablenote"><b>Note:</b> A domain is a search notion
only. That is, items are not stored in domains on eBay, and domains are not
equivalent to eBay categories (although Express may choose to organize and name
some domains to match eBay categories).</span> <br>
<br>
<b>Search Tips:</b></p>
<ul>
<li>Use either Query, ProductReferenceID, or the ExternalProductID fields
to search for specific items and/or products. See the descriptions below for
information about using these fields. (Only one of these query formats can be
used per request.)</li>
<li>Use DepartmentName, AisleName, and/or ProductTypeName to browse or
search within a particular domain. You can also specify the value "Express" in
DepartmentName to retrieve a complete list of all available department, aisle,
and product type names.</li>
<li>Use one or more filters like HighestPrice to refine the
search.</li>
<li>Use sort options like ItemSort to control the order in which the
results are returned.</li>
<li>Use pagination options like EntriesPerPage to control how many results
to return at a time.</li>
<li>Use verbose controls like ItemDetails to specify the data to return
within each result.</li>
</ul>
<p>The item results, catalog product results, and histogram results do not
provide references to each other. That is, the items don't indicate which domains
they were found in, and the histogram doesn't specify which items were counted.
However, you can infer these relationships by modifying your search parameters.
For example, once you determine which domains match your query, you can call
GetSearchResultsExpress again to browse or search each of those domains to find
out which items they contain.
</p>
<p>Please check this
<a href="https://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=928">Knowledge Base article</a>
for updates on current issues with GetSearchResultsExpress.</b><br>
<br></p>



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::AffiliateTrackingDetailsType;
use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::ConditionSelectionCodeType;
use eBay::API::XML::DataType::Enum::ExpressDetailLevelCodeType;
use eBay::API::XML::DataType::Enum::ExpressHistogramSortCodeType;
use eBay::API::XML::DataType::Enum::ExpressItemSortCodeType;
use eBay::API::XML::DataType::Enum::ExpressProductSortCodeType;
use eBay::API::XML::DataType::Enum::ExternalProductCodeType;


my @gaProperties = ( [ 'AffiliateTrackingDetails', 'ns:AffiliateTrackingDetailsType', ''
	     ,'eBay::API::XML::DataType::AffiliateTrackingDetailsType', '1' ]
	, [ 'AisleName', 'xs:string', '', '', '' ]
	, [ 'Condition', 'ns:ConditionSelectionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ConditionSelectionCodeType', '' ]
	, [ 'DepartmentName', 'xs:string', '', '', '' ]
	, [ 'EntriesPerPage', 'xs:int', '', '', '' ]
	, [ 'ExternalProductIDType', 'ns:ExternalProductCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExternalProductCodeType', '' ]
	, [ 'ExternalProductIDValue', 'xs:string', '', '', '' ]
	, [ 'HighestPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'HistogramDetails', 'ns:ExpressDetailLevelCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExpressDetailLevelCodeType', '' ]
	, [ 'HistogramSort', 'ns:ExpressHistogramSortCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExpressHistogramSortCodeType', '' ]
	, [ 'ItemDetails', 'ns:ExpressDetailLevelCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExpressDetailLevelCodeType', '' ]
	, [ 'ItemSort', 'ns:ExpressItemSortCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExpressItemSortCodeType', '' ]
	, [ 'LowestPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'PostalCode', 'xs:string', '', '', '' ]
	, [ 'ProductDetails', 'ns:ExpressDetailLevelCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExpressDetailLevelCodeType', '' ]
	, [ 'ProductReferenceID', 'xs:long', '', '', '' ]
	, [ 'ProductSort', 'ns:ExpressProductSortCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExpressProductSortCodeType', '' ]
	, [ 'ProductTypeName', 'xs:string', '', '', '' ]
	, [ 'Query', 'xs:string', '', '', '' ]
	, [ 'SellerID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAffiliateTrackingDetails()

Container for affiliate tags.
If you use affiliate tags, it is possible to get affiliate commissions
based on calls made by your application.
(See the <a href="https://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a>
for information about commissions.)
Affiliate tags enable the tracking of user activity.
You can use child tags of AffiliateTrackingDetails if you want
call output to include a string, in
ItemArray.Item.ListingDetails.ViewItemURL, that includes
affiliate tracking information.
For GetSearchResultsExpress, the ViewItemURL field is returned only if you specify AffiliateTrackingDetails in the request.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  RequiredInput: No
#    Argument: 'ns:AffiliateTrackingDetailsType'

=cut

sub setAffiliateTrackingDetails {
  my $self = shift;
  $self->{'AffiliateTrackingDetails'} = shift
}

=head2 getAffiliateTrackingDetails()

#    Returns: 'ns:AffiliateTrackingDetailsType'

=cut

sub getAffiliateTrackingDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AffiliateTrackingDetails'
		,'eBay::API::XML::DataType::AffiliateTrackingDetailsType');
}


=head2 setAisleName()

An aisle is a grouping of product types that share a common theme. This
filter limits the search to the specified Express aisle. If not specified,
this filter is ignored by the search engine.<br>
<br>
See DepartmentName for information about how to retrieve all available
department, aisle, and product type names. The valid aisle names are
returned in the Histogram.Department.Aisle.DomainDetails.Name
fields.<br>
<br>
At least one of Query, ProductReferenceID, ExternalProductIDValue (and
Type), SellerID, DepartmentName, AisleName, or ProductTypeName is required.
Optionally, both DepartmentName and AisleName can be specified in the same
request. In this case, the search engine treats the combination as a fully
qualified aisle name (and it returns an error if the combination is
invalid).

MaxLength: 200

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setAisleName {
  my $self = shift;
  $self->{'AisleName'} = shift
}

=head2 getAisleName()

#    Returns: 'xs:string'

=cut

sub getAisleName {
  my $self = shift;
  return $self->{'AisleName'};
}


=head2 setCondition()

A filter that limits the results by the item condition. If not specified,
the default is New. If the item is listed in a category that does not
normally require the condition to be specified (like Event Tickets), the
item is returned regardless of this condition setting.

Default: New

  RequiredInput: No
#    Argument: 'ns:ConditionSelectionCodeType'

=cut

sub setCondition {
  my $self = shift;
  $self->{'Condition'} = shift
}

=head2 getCondition()

#    Returns: 'ns:ConditionSelectionCodeType'

=cut

sub getCondition {
  my $self = shift;
  return $self->{'Condition'};
}


=head2 setDepartmentName()

A department is a grouping of aisles and/or product types that share a
common theme. This filter limits the search to the specified Express
department. If not specified, this filter is ignored by the search
engine.<br>
<br>
You can specify the value "Express" (without quotes) as the department
name to retrieve all departments on Express. With this use case, the
ItemArray and ProductArray nodes aren't returned. The valid department
names are returned in the Histogram.Department.DomainDetails.Name fields.
When DepartmentName=Express, you can only specify HistogramSort and/or
HistogramDetails. Set HistogramDetail to Fine to also retrieve all aisles
and product types. Do not specify ItemDetails or ProductDetails at all in
the request. (Setting the values to None will return an error). Also do
not specify any other query, pagination, price, or sorting fields in the
request.<br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats are
mutually exclusive. That is, they cannot be used together in the same
request. At least one of Query, ProductReferenceID, ExternalProductIDValue
(and Type), SellerID, DepartmentName, AisleName, or ProductTypeName is
required.

MaxLength: 200

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setDepartmentName {
  my $self = shift;
  $self->{'DepartmentName'} = shift
}

=head2 getDepartmentName()

#    Returns: 'xs:string'

=cut

sub getDepartmentName {
  my $self = shift;
  return $self->{'DepartmentName'};
}


=head2 setEntriesPerPage()

The maximum number of entries to return in the ProductArray or ItemArray.
That is, if you specify 10, then up to 10 products and up to 10 items are
returned in the current call's response.<br>
<br>
If the number of entries found is less than the value specified in
EntriesPerPage, then that number of entries is returned instead. For
example, if you specify 10, Express might only return 4 products and 9
items (if no more matches are found). If not specified, the default is 15.

Max: 200
Default: 15
Min: 1

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setEntriesPerPage {
  my $self = shift;
  $self->{'EntriesPerPage'} = shift
}

=head2 getEntriesPerPage()

#    Returns: 'xs:int'

=cut

sub getEntriesPerPage {
  my $self = shift;
  return $self->{'EntriesPerPage'};
}


=head2 setExternalProductIDType()

The combination of ExternalProductIDType and ExternalProductIDValue create
a query that only retrieves items that were listed with
Pre-filled Item Information in categories that support
ISBN or UPC codes (such as Books, DVDs and Movies,
Music, and Video Games).
ExternalProductIDType identifies which type of code you are
searching for. If specified, also specify the ISBN or UPC
code number in ExternalProductIDValue.<br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats
are mutually exclusive. That is, they cannot be used together in the same request. At least one of Query, ProductReferenceID,
ExternalProductIDValue (and Type), SellerID, DepartmentName,
AisleName, or ProductTypeName is required.

  RequiredInput: Conditionally
  OnlyTheseValues: ISBN, UPC
#    Argument: 'ns:ExternalProductCodeType'

=cut

sub setExternalProductIDType {
  my $self = shift;
  $self->{'ExternalProductIDType'} = shift
}

=head2 getExternalProductIDType()

#    Returns: 'ns:ExternalProductCodeType'

=cut

sub getExternalProductIDType {
  my $self = shift;
  return $self->{'ExternalProductIDType'};
}


=head2 setExternalProductIDValue()

An ISBN or UPC code (depending on ExternalProductIDType) for the eBay
catalog product that you are searching for. Only valid when
ExternalProductIDType is specified.

MaxLength: 15

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setExternalProductIDValue {
  my $self = shift;
  $self->{'ExternalProductIDValue'} = shift
}

=head2 getExternalProductIDValue()

#    Returns: 'xs:string'

=cut

sub getExternalProductIDValue {
  my $self = shift;
  return $self->{'ExternalProductIDValue'};
}


=head2 setHighestPrice()

A filter that limits the results to items with a SellingStatus.CurrentPrice
value lower than this value. For example, if you specify 10.01, the results
will include items with a CurrentPrice of 10.00 or lower. Use without
LowestPrice to specify a maximum price, or use with LowestPrice to define a
price range that bounds the results. Must be higher than LowestPrice if both
are specified. If not specified, no maximum price filter is applied to the
query.<br>
<br>
You can specify any double value, but in practice the highest price of any
item on Express is USD 10000 for Express US and (in the future) EUR 10000
for Express Germany. If you specify a value of 0.0 or lower, this filter is
ignored. See "Data Types" in the eBay Web Services Guide for information
about specifying double values.<br>
<br>
Does not control the order in which items are returned. (To sort by highest
total price, use ItemSort.)

Max: Default: Min: 
  RequiredInput: Conditionally
#    Argument: 'ns:AmountType'

=cut

sub setHighestPrice {
  my $self = shift;
  $self->{'HighestPrice'} = shift
}

=head2 getHighestPrice()

#    Returns: 'ns:AmountType'

=cut

sub getHighestPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'HighestPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setHistogramDetails()

Controls the amount of statistical data to return in the response. If not
specified, the default is Coarse.<br>
<br>
This setting is not a filter that limits the search; it only configures
how much detail to retrieve in the resulting histogram. This setting has
no effect on the product or item details.

Default: Coarse

  RequiredInput: No
#    Argument: 'ns:ExpressDetailLevelCodeType'

=cut

sub setHistogramDetails {
  my $self = shift;
  $self->{'HistogramDetails'} = shift
}

=head2 getHistogramDetails()

#    Returns: 'ns:ExpressDetailLevelCodeType'

=cut

sub getHistogramDetails {
  my $self = shift;
  return $self->{'HistogramDetails'};
}


=head2 setHistogramSort()

Specifies the order of the data in the histogram (if any). Controls the
way the histogram data is organized in the response (not the details to
return). If not specified, the default sort order is ItemCount.<br>
<br>
This option has no effect on how item or product results are sorted.
Histogram, item, and product results are sorted independently.<br>
<br>
Note: If you want to sort the results by criteria that eBay has not
defined, retrieve the desired histogram data and then sort the results
locally in your application.

Default: ItemCount

  RequiredInput: No
#    Argument: 'ns:ExpressHistogramSortCodeType'

=cut

sub setHistogramSort {
  my $self = shift;
  $self->{'HistogramSort'} = shift
}

=head2 getHistogramSort()

#    Returns: 'ns:ExpressHistogramSortCodeType'

=cut

sub getHistogramSort {
  my $self = shift;
  return $self->{'HistogramSort'};
}


=head2 setItemDetails()

Selects the set of fields to retrieve for each item that matches the
query. If not specified, the default is Coarse.<br>
<br>
This setting is not a filter that limits the search; it only configures
which fields to retrieve for each item found. This setting has no effect
on the histogram or product details.

Default: Coarse

  RequiredInput: No
#    Argument: 'ns:ExpressDetailLevelCodeType'

=cut

sub setItemDetails {
  my $self = shift;
  $self->{'ItemDetails'} = shift
}

=head2 getItemDetails()

#    Returns: 'ns:ExpressDetailLevelCodeType'

=cut

sub getItemDetails {
  my $self = shift;
  return $self->{'ItemDetails'};
}


=head2 setItemSort()

Specifies the order in which listings (if any) are returned in the result
set. If not specified, the items are sorted by relevance (as determined by
eBay). If you choose to sort by total cost, a PostalCode must also be
specified (so that eBay can calculate the shipping cost as part of the
total cost for each item).<br>
<br>
Controls the way the data is organized in the response (not the details to
return).<br>
<br>
This option has no effect on how histogram or product results are sorted.
Histogram, item, and product results are sorted independently.<br>
<br>
Note: If you want to sort the results by criteria that eBay has not
defined, retrieve all available pages and then sort the results locally in
your application.

Default: Relevance

  RequiredInput: No
#    Argument: 'ns:ExpressItemSortCodeType'

=cut

sub setItemSort {
  my $self = shift;
  $self->{'ItemSort'} = shift
}

=head2 getItemSort()

#    Returns: 'ns:ExpressItemSortCodeType'

=cut

sub getItemSort {
  my $self = shift;
  return $self->{'ItemSort'};
}


=head2 setLowestPrice()

A filter that limits the results to items with a
SellingStatus.CurrentPrice value equal to or higher than this value. For
example, if you specify 6.00, the results will include items with a
CurrentPrice of 6.00 or higher. If specified, HighestPrice must also be
specified; otherwise, the lowest price filter is ignored. Must be lower
than HighestPrice. If not specified or if the value is less than 0.0, no
minimum price filter is applied to the query.<br>
<br>
You can specify any double value, but in practice the highest price of any
item on Express is USD 10000 for Express US and (in the future) EUR 10000
for Express Germany. See "Data Types" in the eBay Web Services Guide for
information about specifying double values .<br>
<br>
Does not control the order in which items are returned. (To sort by lowest
total price, use ItemSort.)

Max: Default: Min: 
  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setLowestPrice {
  my $self = shift;
  $self->{'LowestPrice'} = shift
}

=head2 getLowestPrice()

#    Returns: 'ns:AmountType'

=cut

sub getLowestPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LowestPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setPageNumber()

Specifies the number of the page of data to return in the current call. If
not specified, the default is 1 (the first page).

Max: 90
Default: 1
Min: 1

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setPostalCode()

Postal code of the buyer. For the US site, this is a 5-digit zip code.
(Other sites may support longer alphanumeric values in the future.) The
postal code enables Express to calculate the item's default shipping cost
based on the buyer's postal code, the postal code defined on the item, and
the cost of the default shipping service that the seller specified in the
listing. The default shipping cost is returned in the
Item.ShippingDetails.DefaultShippingCost field. If not specified, items
with calculated shipping will return an
Item.ShippingDetails.ShippingRateErrorMessage string that indicates that a
postal code is needed to calculate shipping.<br>
<br>
Required if ItemSort is set to LowestTotalCost or HighestTotalCost
(because the total cost calculation depends on the shipping cost
calculation).<br>
<br>
This is not a query or filter, so it has no effect on which items or
products are returned.

MaxLength: 5

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setPostalCode {
  my $self = shift;
  $self->{'PostalCode'} = shift
}

=head2 getPostalCode()

#    Returns: 'xs:string'

=cut

sub getPostalCode {
  my $self = shift;
  return $self->{'PostalCode'};
}


=head2 setProductDetails()

Selects the set of fields to retrieve for each catalog product that
matches the query. If not specified, the default is Coarse.<br>
<br>
This setting is not a filter that limits the search; it only configures
which fields to retrieve for each product found. This setting has no
effect on the histogram or item details.

Default: Coarse

  RequiredInput: No
#    Argument: 'ns:ExpressDetailLevelCodeType'

=cut

sub setProductDetails {
  my $self = shift;
  $self->{'ProductDetails'} = shift
}

=head2 getProductDetails()

#    Returns: 'ns:ExpressDetailLevelCodeType'

=cut

sub getProductDetails {
  my $self = shift;
  return $self->{'ProductDetails'};
}


=head2 setProductReferenceID()

The global reference ID for an eBay catalog product. eBay catalog products
provide stock information that sellers can use to pre-fill Item Specifics
and other listing details. Use this query to retrieve basic details about
the catalog product (returned in ProductArray) along with items (in
ItemArray) that were
listed with any version of the product.<br>
<br>
To determine valid reference IDs, call GetSearchResultsExpress without
using this value. The IDs that match the query (if any) are returned in
ProductArray.Product.ProductReferenceID fields.<br>
<br>
<span class="tablenote"><b>Note:</b>
This value is not the same as the ProductID used in AddItem and related calls. A ProductID represents a particular version
of a catalog product, which is associated with a particular set of
Item Specifics and other details. A ProductReferenceID is a more generic
or global reference to a catalog product, which is useful for buy-side searching. One ProductReferenceID can be associated with multiple ProductIDs.</span><br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats are
mutually exclusive. That is, they cannot be used together in the same
request. At least one of Query, ProductReferenceID, ExternalProductIDValue
(and Type), SellerID, DepartmentName, AisleName, or ProductTypeName is
required.<br>
<br>
As of mid-2008, some sites (such as eBay US, Germany, Austria, and Switzerland) are 
updating, replacing, deleting, or merging some products (as a result of migrating from one
catalog data provider to another). 
If you specify one of these products, the call may return a warning, 
or it may return an error if the product has been deleted.

Max: Default: Min: 
  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut

sub setProductReferenceID {
  my $self = shift;
  $self->{'ProductReferenceID'} = shift
}

=head2 getProductReferenceID()

#    Returns: 'xs:long'

=cut

sub getProductReferenceID {
  my $self = shift;
  return $self->{'ProductReferenceID'};
}


=head2 setProductSort()

Specifies the order in which Express products are returned in a result
set. If not specified, the products are sorted by sales rank (bestselling
first).<br>
<br>
This option has no effect on how histogram or item results are sorted.
Histogram, item, and product results are sorted independently.<br>
<br>
Note: If you want to sort the results by criteria that eBay has not
defined, retrieve all available pages and then sort the results locally in
your application.<br>
<br>
Controls the way the data is organized in the response (not the details to
return).

Default: SalesRank

  RequiredInput: No
#    Argument: 'ns:ExpressProductSortCodeType'

=cut

sub setProductSort {
  my $self = shift;
  $self->{'ProductSort'} = shift
}

=head2 getProductSort()

#    Returns: 'ns:ExpressProductSortCodeType'

=cut

sub getProductSort {
  my $self = shift;
  return $self->{'ProductSort'};
}


=head2 setProductTypeName()

A product type is a type of good or service that can be purchased. This
filter limits the search to the specified Express product type. If not
specified, this filter is ignored by the search engine.<br>
<br>
<b>Note:</b> Express product types are not eBay catalog
products. This field does not support eBay catalog product names or
IDs.<br>
<br>
See DepartmentName for information about how to retrieve all available
department, aisle, and product type names. The valid product type names
are returned in Histogram.Department.Aisle.ProductType.DomainDetails.Name
fields.<br>
<br>
Optionally, DepartmentName and/or AisleName can be specified in the same
request with ProductTypeName. In this case, the search engine treats the
combination as a fully qualified product type name (and it returns an
error if the combination is invalid).

MaxLength: 200

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setProductTypeName {
  my $self = shift;
  $self->{'ProductTypeName'} = shift
}

=head2 getProductTypeName()

#    Returns: 'xs:string'

=cut

sub getProductTypeName {
  my $self = shift;
  return $self->{'ProductTypeName'};
}


=head2 setQuery()

A free-text query that retrieves items, information about eBay catalog
products that were used to list the items, and/or applicable domain
details. For a quick, targeted search, use keywords that best fit the item
you're looking for. You can also search by brand name or descriptive
features. The search engine checks all specified keywords against the item
title, description, eBay category, Item Specifics, and/or Pre-filled Item
Information. (Express does not necessarily check all Item Specifics
defined on the item.) The exact combination of fields that are checked for
any given set of keywords varies by a number of factors that are not
disclosed in this documentation.<br>
<br>
Specify at least two characters when you use Query. If you specify
multiple words, AND logic is used. The keywords can be specified any
order. The words "and" and "or" are treated like any other word. Only use
"and", "or", or "the" if you are searching for listings containing these
words.<br>
<br>
You can control AND or OR logic by including certain modifiers. Wildcards
(e.g., *) are also supported. Be careful when using spaces before or after
modifiers and wildcards (+, -, or *). These are the same modifiers that
GetSearchResults supports. See "Searching by Keywords" in the eBay Web
Services Guide for a list of valid modifiers and examples. Modifiers do
not count in the 2-character minimum.
<br>
<br>
Alternatively, you can specify an item ID to retrieve a specific item's
Express search details. To search by ISBN or UPC, use
ExternalProductIDType and ExternalProductIDValue instead.<br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats are
mutually exclusive. That is, they cannot be used together in the same
request. At least one of Query, ProductReferenceID, ExternalProductIDValue
(and Type), SellerID, DepartmentName, AisleName, or ProductTypeName is
required.

MaxLength: 350

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setQuery {
  my $self = shift;
  $self->{'Query'} = shift
}

=head2 getQuery()

#    Returns: 'xs:string'

=cut

sub getQuery {
  my $self = shift;
  return $self->{'Query'};
}


=head2 setSellerID()

A filter that limits the search to a particular seller's listings that are
included on Express. Retrieves all of the seller's eligible items, without
consolidating (deduping) similar items into single representative results.
If specified, you can only search within one seller's listings per call.
(It is not possible to exclude a particular seller's listings from the
search.) If not specified, the engine searches across all listings on
Express. If the seller has no items listed on Express, no results are
returned.

  RequiredInput: No
#    Argument: 'ns:UserIDType'

=cut

sub setSellerID {
  my $self = shift;
  $self->{'SellerID'} = shift
}

=head2 getSellerID()

#    Returns: 'ns:UserIDType'

=cut

sub getSellerID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
