# Generated by default/object.tt
package Paws::Chime::Channel;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Paws::Chime::Identity');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has LastMessageTimestamp => (is => 'ro', isa => 'Str');
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has Metadata => (is => 'ro', isa => 'Str');
  has Mode => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Privacy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::Channel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::Channel object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., Privacy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::Channel object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

The details of a channel.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

The ARN of the channel.


=head2 CreatedBy => L<Paws::Chime::Identity>

The C<AppInstanceUser> who created the channel.


=head2 CreatedTimestamp => Str

The time at which the C<AppInstanceUser> created the channel.


=head2 LastMessageTimestamp => Str

The time at which a member sent the last message in the channel.


=head2 LastUpdatedTimestamp => Str

The time at which a channel was last updated.


=head2 Metadata => Str

The channel's metadata.


=head2 Mode => Str

The mode of the channel.


=head2 Name => Str

The name of the channel.


=head2 Privacy => Str

The channel's privacy setting.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

