package Daje::Plugin::Workflow;
use Mojo::Base 'Mojolicious::Plugin', -signatures;
use v5.40;

# NAME
# ====
#
# Daje::Plugin::Workflow - Plugin to use Daje::Wrokflow
#
# SYNOPSIS
# ========
#
#     use Daje::Plugin::Workflow;
#
#     Expected config data
#
#     workflow => {
#         loader => {
#             path => '/home/xxxx/Project/Workflows',
#             type => 'workflow'
#         }
#     }
#
# DESCRIPTION
# ===========
#
# Daje::Plugin::Workflow is the Mojolicious plugin for Daje::Workflow
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

our $VERSION = "0.35";

use Data::Dumper;
use Daje::Workflow::Database;
use Daje::Workflow::Loader;
use Daje::Workflow;
use Daje::Database::Migrator;

sub register ($self, $app, $config) {

    $app->log->debug("Daje::Plugin::Workflow::register starts");

    my $migration->{class} = 'Daje::Workflow::Database';
    $migration->{name} = 'workflow';
    $migration->{migration} = 4;
    my $migrations;
    push @{$migrations}, $migration;
    try {
        Daje::Database::Migrator->new(
            pg         => $app->pg,
            migrations => $migrations,
        )->migrate();
    } catch ($e) {
        $app->log->error($e);
    };
    push @{$app->routes->namespaces}, 'Daje::Controller::Workflows';

    my $loader;
    try { # '/home/jan/Project/Daje-Workflow-Workflows/Workflows'
        $loader = Daje::Workflow::Loader->new(
            path => $app->config('workflow')->{loader}->{path},
            type => $app->config('workflow')->{loader}->{type},
        );
        $loader->load();
    } catch ($e) {
        $app->log->error($e);
    };

    my $workflow_engine;
    try {
        $workflow_engine = Daje::Workflow->new(
            pg     => $app->pg,
            loader => $loader->loader,
        );
    } catch ($e) {
        $app->log->error($e);
    };

    my $r = $app->auth;

    $r->put('workflow/execute')->to('Workflows#execute');

    $app->helper(workflow_engine => sub {$workflow_engine});

    $app->log->debug("Daje::Plugin::Workflow registered");
}





1;

__END__









#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Plugin::Workflow - Plugin to use Daje::Wrokflow



=head1 SYNOPSIS


    use Daje::Plugin::Workflow;

    Expected config data

    workflow => {
        loader => {
            path => '/home/xxxx/Project/Workflows',
            type => 'workflow'
        }
    }



=head1 DESCRIPTION


Daje::Plugin::Workflow is the Mojolicious plugin for Daje::Workflow



=head1 REQUIRES

L<Daje::Database::Migrator> 

L<Daje::Workflow> 

L<Daje::Workflow::Loader> 

L<Daje::Workflow::Database> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 register

 register();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

