/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.XpiDriverService;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final String MARIONETTE = "marionette";
    protected FirefoxBinary binary;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    @Deprecated
    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(new FirefoxOptions(Objects.requireNonNull(desiredCapabilities, "No capabilities seen")));
    }

    @Deprecated
    public FirefoxDriver(GeckoDriverService service, Capabilities desiredCapabilities) {
        this(Objects.requireNonNull(service, "No geckodriver service provided"), new FirefoxOptions(desiredCapabilities));
    }

    public FirefoxDriver(FirefoxOptions options) {
        super(FirefoxDriver.toExecutor(options), FirefoxDriver.dropCapabilities(options));
    }

    public FirefoxDriver(GeckoDriverService service) {
        super(new DriverCommandExecutor(service), (Capabilities)new FirefoxOptions());
    }

    public FirefoxDriver(GeckoDriverService service, FirefoxOptions options) {
        super(new DriverCommandExecutor(service), FirefoxDriver.dropCapabilities(options));
    }

    private static CommandExecutor toExecutor(FirefoxOptions options) {
        DriverService.Builder builder;
        Objects.requireNonNull(options, "No options to construct executor from");
        if (!Boolean.parseBoolean(System.getProperty("webdriver.firefox.marionette", "true")) || options.isLegacy()) {
            FirefoxProfile profile = options.getProfile();
            if (profile == null) {
                profile = new FirefoxProfile();
                options.setCapability(PROFILE, profile);
            }
            builder = XpiDriverService.builder().withBinary(options.getBinary()).withProfile(profile);
        } else {
            builder = new GeckoDriverService.Builder().usingFirefoxBinary(options.getBinary());
        }
        return new DriverCommandExecutor((DriverService)builder.build());
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        DesiredCapabilities caps;
        if (capabilities == null) {
            return new DesiredCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet<String> toRemove = Sets.newHashSet(BINARY, PROFILE);
            caps = new DesiredCapabilities(Maps.filterKeys(capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new DesiredCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom(capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", proxy);
        }
        return caps;
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

