/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSelectElement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.EvaluatorException;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF}), @JsxClass(isJSObject=false, value={SupportedBrowser.IE})})
public class HTMLOptionsCollection
extends SimpleScriptable {
    private HtmlSelect htmlSelect_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public HTMLOptionsCollection() {
    }

    public HTMLOptionsCollection(SimpleScriptable parentScope) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public String getClassName() {
        if (this.getWindow().getWebWindow() != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_HAS_SELECT_CLASS_NAME)) {
            return "HTMLSelectElement";
        }
        return super.getClassName();
    }

    public void initialize(HtmlSelect select) {
        WebAssert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.htmlSelect_ == null || index < 0) {
            return Undefined.instance;
        }
        if (index >= this.htmlSelect_.getOptionSize()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_NULL_FOR_OUTSIDE)) {
                return null;
            }
            return Undefined.instance;
        }
        return this.getScriptableFor(this.htmlSelect_.getOption(index));
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.htmlSelect_ == null) {
            super.put(name, start, value);
            return;
        }
        HTMLSelectElement parent = (HTMLSelectElement)this.htmlSelect_.getScriptableObject();
        if (!this.has(name, start) && ScriptableObject.hasProperty((Scriptable)parent, name)) {
            ScriptableObject.putProperty((Scriptable)parent, name, value);
        } else {
            super.put(name, start, value);
        }
    }

    @JsxFunction
    public Object item(int index) {
        return this.get(index, null);
    }

    @Override
    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            HTMLOptionElement option = (HTMLOptionElement)newValue;
            HtmlOption htmlOption = (HtmlOption)option.getDomNodeOrNull();
            if (index >= this.getLength()) {
                this.setLength(index);
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
    }

    @JsxGetter
    public int getLength() {
        return this.htmlSelect_.getOptionSize();
    }

    @JsxSetter
    public void setLength(int newLength) {
        if (newLength < 0) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_IGNORE_NEGATIVE_LENGTH)) {
                return;
            }
            throw Context.reportRuntimeError("Length is negative");
        }
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            for (int i = currentLength; i < newLength; ++i) {
                HtmlOption option = (HtmlOption)HTMLParser.getFactory("option").createElement(this.htmlSelect_.getPage(), "option", null);
                this.htmlSelect_.appendOption(option);
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_DONT_ADD_EMPTY_TEXT_CHILD_WHEN_EXPANDING)) continue;
                option.appendChild(new DomText(option.getPage(), ""));
            }
        }
    }

    @JsxFunction
    public void add(Object newOptionObject, Object beforeOptionObject) {
        int index = this.getLength();
        HtmlOption htmlOption = (HtmlOption)((HTMLOptionElement)newOptionObject).getDomNodeOrNull();
        HtmlOption beforeOption = null;
        if (beforeOptionObject instanceof Number) {
            index = (Integer)Context.jsToJava(beforeOptionObject, Integer.class);
            if (index < 0 || index >= this.getLength()) {
                this.htmlSelect_.appendOption(htmlOption);
                return;
            }
            beforeOption = (HtmlOption)((HTMLOptionElement)this.item(index)).getDomNodeOrDie();
        } else if (beforeOptionObject instanceof HTMLOptionElement && (beforeOption = (HtmlOption)((HTMLOptionElement)beforeOptionObject).getDomNodeOrDie()).getParentNode() != this.htmlSelect_) {
            throw new EvaluatorException("Unknown option.");
        }
        if (null == beforeOption) {
            this.htmlSelect_.appendOption(htmlOption);
            return;
        }
        beforeOption.insertBefore(htmlOption);
    }

    @JsxFunction
    public void remove(int index) {
        int idx = index;
        BrowserVersion browser = this.getBrowserVersion();
        if (idx < 0) {
            if (browser.hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_IGNORE_IF_INDEX_NEGATIVE)) {
                return;
            }
            if (index < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_THROWS_IF_NEGATIV)) {
                throw Context.reportRuntimeError("Invalid index for option collection: " + index);
            }
        }
        if ((idx = Math.max(idx, 0)) >= this.getLength()) {
            if (browser.hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_IGNORE_IF_INDEX_TOO_LARGE)) {
                return;
            }
            idx = 0;
        }
        this.htmlSelect_.removeOption(idx);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_IN_ALWAYS_TRUE)) {
            return true;
        }
        return super.has(index, start);
    }

    @JsxGetter
    public int getSelectedIndex() {
        return this.htmlSelect_.getSelectedIndex();
    }

    @JsxSetter
    public void setSelectedIndex(int index) {
        this.htmlSelect_.setSelectedIndex(index);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public NodeList getChildNodes() {
        return new NodeList(this.htmlSelect_, false){

            @Override
            protected List<DomNode> computeElements() {
                ArrayList<DomNode> response = new ArrayList<DomNode>();
                for (DomNode child : HTMLOptionsCollection.this.htmlSelect_.getChildren()) {
                    response.add(child);
                }
                return response;
            }
        };
    }
}

