/* -*- buffer-read-only: t -*-
 *
 *    regcharclass.h
 *
 *    Copyright (C) 2007, 2011 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/regcharclass.pl.
 * Any changes made here will be lost!
 * WARNING: These macros are for internal Perl core use only, and may be
 * changed or removed without notice.
 */


#ifndef H_REGCHARCLASS   /* Guard against nested #includes */
#define H_REGCHARCLASS 1

#if 'A' == 65 /* ASCII/Latin1 */
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( is_utf8 ) ?                                                         \
	( ( 0xC2 == ((U8*)s)[0] ) ?                                         \
	    ( ( 0x85 == ((U8*)s)[1] ) ? 2 : 0 )                             \
	: ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
    : ( 0x85 == ((U8*)s)[0] ) )                                             \
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( is_utf8 ) ?                                                         \
	( ( ( 0xC2 == ((U8*)s)[0] ) && ( 0x85 == ((U8*)s)[1] ) ) ? 2 : 0 )  \
    : ( 0x85 == ((U8*)s)[0] ) )                                             \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) ? 1                    \
    : ( !( is_utf8 ) ) ?                                                    \
	( 0x85 == ((U8*)s)[0] )                                             \
    : 0 )                                                                   \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( 0xC2 == ((U8*)s)[0] ) ?                                             \
	( ( 0x85 == ((U8*)s)[1] ) ? 2 : 0 )                                 \
    : ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( 0xC2 == ((U8*)s)[0] ) && ( 0x85 == ((U8*)s)[1] ) ) ? 2 : 0 )      \
: ((e)-(s) > 0) ?                                                           \
    ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D )                          \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) || 0x85 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x85 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x9A == ((U8*)s)[1] ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0x8A ) || 0xAF == ((U8*)s)[2] ) ? 3 : 0 )      \
    : ( ( 0x81 == ((U8*)s)[1] ) && ( 0x9F == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xE3 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( 0xEF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xBC == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x90 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x99 ) || ( 0xA1 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xA6 ) ) ? 3 : 0 )\
    : ( ( 0xBD == ((U8*)s)[1] ) && ( 0x81 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x9A == ((U8*)s)[1] ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0x8A ) || ( ((U8*)s)[2] & 0xFE ) == 0xA8 || 0xAF == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x81 == ((U8*)s)[1] ) && ( 0x9F == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xE3 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( 0xEF == ((U8*)s)[0] ) ) && ( 0xBF == ((U8*)s)[1] ) ) && ( 0xBD == ((U8*)s)[2] ) ) ? 3 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xEF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xB7 == ((U8*)s)[1] ) ?                                             \
	( ( 0x90 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xAF ) ? 3 : 0 )          \
    : ( ( 0xBF == ((U8*)s)[1] ) && ( ((U8*)s)[2] >= 0xBE ) ) ? 3 : 0 )      \
: ( 0xF0 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ((U8*)s)[1] == 0x9F || ( ( ((U8*)s)[1] & 0xEF ) == 0xAF ) ) && ( 0xBF == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xBE ) ) ? 4 : 0 )\
: ( 0xF1 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xF3 ) ?                          \
    ( ( ( ( ( ((U8*)s)[1] & 0xCF ) == 0x8F ) && ( 0xBF == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xBE ) ) ? 4 : 0 )\
: ( ( ( ( 0xF4 == ((U8*)s)[0] ) && ( 0x8F == ((U8*)s)[1] ) ) && ( 0xBF == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xBE ) ) ? 4 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( 0xED == ((U8*)s)[0] ) && ( ((U8*)s)[1] >= 0xA0 ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x8F == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xD8 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x9C == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x85 == ((U8*)s)[1] ) ?                                             \
	( ( 0x9F == ((U8*)s)[2] || 0xA0 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( 0x9A == ((U8*)s)[1] ) ?                                             \
	( ( 0x80 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( 0x9E == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] & 0xFE ) == 0xB4 ) ? 3 : 0 )                      \
    : ( ( 0xA0 == ((U8*)s)[1] ) && ( 0x8B <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x8E ) ) ? 3 : 0 )\
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0xBE ) ? 3 : 0 )                                 \
    : ( 0x81 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x81 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x93 ) || ( 0x95 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xAF ) ) ? 3 : 0 )\
    : ( 0x86 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0x90 ) ? 3 : 0 )                                 \
    : ( ( 0x87 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x90 ) || ( 0x94 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x9C ) || ( 0x9F <= ((U8*)s)[1] && ((U8*)s)[1] <= 0xAF ) || ( ((U8*)s)[1] & 0xFE ) == 0xB8 ) ?\
	3                                                                   \
    : ( 0x91 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0x9F ) ? 3 : 0 )                                 \
    : ( 0x9D == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0xB5 ) ? 3 : 0 )                                 \
    : ( ( 0x9E == ((U8*)s)[1] ) && ( ((U8*)s)[2] >= 0x94 ) ) ? 3 : 0 )      \
: ( 0xE3 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0x83 ) || ( 0x88 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xA0 ) || 0xB0 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x85 == ((U8*)s)[1] ) && ( 0xA4 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xEF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xB4 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0xBE ) ? 3 : 0 )                                 \
    : ( 0xB8 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0x8F ) ? 3 : 0 )                                 \
    : ( 0xB9 == ((U8*)s)[1] ) ?                                             \
	( ( 0x85 == ((U8*)s)[2] || 0x86 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( 0xBB == ((U8*)s)[1] ) ?                                             \
	( ( 0xBF == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( 0xBE == ((U8*)s)[1] ) ?                                             \
	( ( 0xA0 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0xBF == ((U8*)s)[1] ) && ( 0xB0 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xB8 ) ) ? 3 : 0 )\
: ( 0xF0 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x9B == ((U8*)s)[1] ) ?                                             \
	( ( ( 0xB2 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFC ) == 0xA0 ) ) ? 4 : 0 )\
    : ( ( ( 0x9D == ((U8*)s)[1] ) && ( 0x85 == ((U8*)s)[2] ) ) && ( 0xB3 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0xBA ) ) ? 4 : 0 )\
: ( ( 0xF3 == ((U8*)s)[0] ) && ( 0xA0 == ((U8*)s)[1] ) ) ? 4 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x61 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xC5 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0xBF == ((U8*)s)[1] ) && ( 0xC5 == ((U8*)s)[2] ) ) && ( 0xBF == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xBC == ((U8*)s)[1] ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xCE == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0xAC ) ?                              \
	    ( ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((U8*)s)[1] || 0xB7 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((U8*)s)[1] ) && ( 0xCD == ((U8*)s)[2] ) ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((U8*)s)[0] ) ?                                             \
	( ( 0x81 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xCC == ((U8*)s)[2] ) && ( 0x93 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x93 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((U8*)s)[1] ) && ( 0xCE == ((U8*)s)[2] ) ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((U8*)s)[0] ) ?                                             \
	( ( 0xA5 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD6 == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD5 == ((U8*)s)[2] ) && ( ( ( ((U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((U8*)s)[3] == 0xAB || ((U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((U8*)s)[1] ) && ( 0xD5 == ((U8*)s)[2] ) ) && ( 0xB6 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((U8*)s)[0] ) ?                                             \
	( ( 0xBC == ((U8*)s)[1] ) ?                                         \
	    ( ( ( ( ( ((U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0xB0 ) || ((U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x61 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xC5 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0xBF == ((U8*)s)[1] ) && ( 0xC5 == ((U8*)s)[2] ) ) && ( 0xBF == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xBC == ((U8*)s)[1] ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xCE == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0xAC ) ?                              \
	    ( ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((U8*)s)[1] || 0xB7 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((U8*)s)[1] ) && ( 0xCD == ((U8*)s)[2] ) ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((U8*)s)[0] ) ?                                             \
	( ( 0x81 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xCC == ((U8*)s)[2] ) && ( 0x93 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x93 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((U8*)s)[1] ) && ( 0xCE == ((U8*)s)[2] ) ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((U8*)s)[0] ) ?                                             \
	( ( 0xA5 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD6 == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD5 == ((U8*)s)[2] ) && ( ( ( ((U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((U8*)s)[3] == 0xAB || ((U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((U8*)s)[1] ) && ( 0xD5 == ((U8*)s)[2] ) ) && ( 0xB6 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x61 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0xBC == ((U8*)s)[1] ) ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] || 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0x73 == ((U8*)s)[0] ) && ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x61 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xC5 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0xBF == ((U8*)s)[1] ) && ( 0xC5 == ((U8*)s)[2] ) ) && ( 0xBF == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xBC == ((U8*)s)[1] ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xCE == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0xAC ) ?                              \
	    ( ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((U8*)s)[1] || 0xB7 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xCE == ((U8*)s)[4] ) && ( 0xB9 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB9 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x88 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xCC == ((U8*)s)[4] ) ?                             \
			( ( ( ((U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 0 )      \
		    : ( ( 0xCD == ((U8*)s)[4] ) && ( 0x82 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCF == ((U8*)s)[0] ) ?                                             \
	( ( 0x81 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xCC == ((U8*)s)[2] ) && ( 0x93 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x88 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xCC == ((U8*)s)[4] ) ?                             \
			( ( ( ((U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 0 )      \
		    : ( ( 0xCD == ((U8*)s)[4] ) && ( 0x82 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x93 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xCC == ((U8*)s)[4] ) ?                             \
			( ( ( ((U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 4 )      \
		    : ( ( 0xCD == ((U8*)s)[4] ) && ( 0x82 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xCE == ((U8*)s)[4] ) && ( 0xB9 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((U8*)s)[1] ) && ( 0xCE == ((U8*)s)[2] ) ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((U8*)s)[0] ) ?                                             \
	( ( 0xA5 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD6 == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD5 == ((U8*)s)[2] ) && ( ( ( ((U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((U8*)s)[3] == 0xAB || ((U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((U8*)s)[1] ) && ( 0xD5 == ((U8*)s)[2] ) ) && ( 0xB6 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((U8*)s)[0] ) ?                                             \
	( ( 0xBC == ((U8*)s)[1] ) ?                                         \
	    ( ( ( ( ( ((U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0xB0 ) || ((U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xDF ) == 0x46 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xDF ) == 0x46 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xDF ) == 0x49 ) || ( ( ((U8*)s)[2] & 0xDF ) == 0x4C ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xDF ) == 0x49 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xDF ) == 0x53 ) && ( ( ( ((U8*)s)[1] & 0xDF ) == 0x53 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xDF ) == 0x46 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xDF ) == 0x46 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x49 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xDF ) == 0x53 ) && ( ( ( ((U8*)s)[1] & 0xDF ) == 0x53 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0xC3 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x9F == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC4 == ((U8*)s)[0] || 0xC7 == ((U8*)s)[0] ) ?                          \
    ( ( 0xB0 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC5 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x89 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xDF ) == 0x90 ) ? 2 : 0 )                          \
: ( 0xD6 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x87 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xBA == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x96 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x9A ) || 0x9E == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0xBD == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] & 0xF9 ) == 0x90 ) ? 3 : 0 )                      \
    : ( 0xBE == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xE0 ) == 0x80 ) || ( ( ((U8*)s)[2] & 0xF0 ) == 0xA0 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0xB2 ) || ( ( ((U8*)s)[2] & 0xF7 ) == 0xB4 ) ) ? 3 : 0 )\
    : ( ( 0xBF == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xCA ) == 0x82 ) || ( ( ((U8*)s)[2] & 0xF7 ) == 0x84 ) || ((U8*)s)[2] == 0xA4 || ( ( ((U8*)s)[2] & 0xF7 ) == 0xB4 ) ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((U8*)s)[0] ) && ( 0xAC == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] <= 0x86 ) || ( 0x93 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x97 ) ) ) ? 3 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ((U8*)s)[0] <= 0x7F ) ? 1                                               \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xC2 ) ?                                      \
    2                                                                       \
: ( 0xC4 == ((U8*)s)[0] || 0xC7 == ((U8*)s)[0] ) ?                          \
    ( ( 0xB0 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC5 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x89 == ((U8*)s)[1] || 0xB8 == ((U8*)s)[1] || 0xBF == ((U8*)s)[1] ) ? 2 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                          \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0xBA == ((U8*)s)[1] ) && ( ( 0x96 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x9A ) || 0x9E == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x84 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((U8*)s)[0] ) && ( 0xAC == ((U8*)s)[1] ) ) && ( ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ((U8*)s)[0] <= 0x7F ) ? 1                                               \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xC2 ) ?                                      \
    2                                                                       \
: ( 0xC4 == ((U8*)s)[0] || 0xC7 == ((U8*)s)[0] ) ?                          \
    ( ( 0xB0 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC5 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x89 == ((U8*)s)[1] || 0xB8 == ((U8*)s)[1] || 0xBF == ((U8*)s)[1] ) ? 2 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xBC == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                          \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0xBA == ((U8*)s)[1] ) && ( ( 0x96 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x9A ) || 0x9E == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x84 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((U8*)s)[0] ) && ( 0xAC == ((U8*)s)[1] ) ) && ( ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( 0x09 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x20 == ((U8*)s)[0] ) ? 1\
    : (! is_utf8 ) ?                                                        \
	    ( 0x85 == ((U8*)s)[0] )                                         \
	: ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ?                          \
	    ( ( 0xC2 == ((U8*)s)[0] ) ?                                     \
		( ( 0x85 == ((U8*)s)[1] ) ? 2 : 0 )                         \
	    : ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x8E || ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
	: 0 )                                                               \
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( ( 0x09 <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x20 == cp || ( 0x20 < cp &&                                              \
( 0x85 == cp || ( 0x85 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) )

#endif	/* ASCII/Latin1 */

#if 'A' == 193 /* EBCDIC 1047 */ \
     && '\\' == 224 && '[' == 173 && ']' == 189 && '{' == 192 && '}' == 208 \
     && '^' == 95 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((U8*)s)[0] ) ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x56 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x73 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x73 == ((U8*)s)[1] ) ) ? ( ( 0x67 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x68 ) ) ? 4 : 0 )\
	: ( ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) && ( 0x42 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x73 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((U8*)s)[0] ) ) && ( 0x73 == ((U8*)s)[1] ) ) && ( 0x73 == ((U8*)s)[2] ) ) && ( 0x71 == ((U8*)s)[3] ) ) ? 4 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x73 == ((U8*)s)[1] ) ?                                             \
	( ( 0x55 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( 0x56 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( ( 0x73 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x72 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] || 0xEA == ((U8*)s)[0] || 0xEC == ((U8*)s)[0] ) ?   \
    ( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x73 == ((U8*)s)[2] ) ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x72 ) ) ? 4 : 0 )\
: ( 0xED == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] == 0x4A || ((U8*)s)[1] == 0x52 || ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) || ((U8*)s)[1] == 0x58 || ((U8*)s)[1] == 0x62 || ( ( ((U8*)s)[1] & 0xFD ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFD ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFD ) == 0x71 ) ) && ( 0x73 == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x72 ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEE == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x73 == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x72 ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x65 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) ? 4 : 0 )

/*
	UTF8_CHAR: Matches legal UTF-EBCDIC encoded characters from 2 through 3 bytes

	0xA0 - 0x3FFF
*/
/*** GENERATED CODE ***/
#define is_UTF8_CHAR_utf8_no_length_checks(s)                               \
( ( 0x80 == ((U8*)s)[0] || ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x90 ) || ( 0x9A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xA0 ) || ( 0xAA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xAC ) || ( 0xAE <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xB6 ) ) ?\
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( ( ( ( ( ((U8*)s)[0] & 0xFC ) == 0xB8 ) || ((U8*)s)[0] == 0xBC || ( ( ((U8*)s)[0] & 0xFE ) == 0xBE ) || ( ( ((U8*)s)[0] & 0xEE ) == 0xCA ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xCC ) ) && ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xB1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB8 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x57 == ((U8*)s)[1] ) && ( 0x70 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBB == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ?                                             \
	( ( 0x73 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x63 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x71 == ((U8*)s)[1] ) && ( 0x63 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 == ((U8*)s)[1] ) && ( 0x52 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x55 ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] || ( 0x54 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x43 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x42 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x62 == ((U8*)s)[2] || ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x44 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
    : ( ( 0x53 == ((U8*)s)[1] ) && ( ( 0x57 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ((U8*)s)[1] & 0xE7 ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ((U8*)s)[1] == 0x4A || ( ( ((U8*)s)[1] & 0xFC ) == 0x54 ) || ((U8*)s)[1] == 0x58 || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ((U8*)s)[1] == 0x71 ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x6A == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x64 ) ) ? 3 : 0 )\
    : ( ( 0x70 == ((U8*)s)[1] ) && ( ( 0x63 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x57 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x62 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) || ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] || 0x57 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x45 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x73 == ((U8*)s)[1] ) ?                                             \
	( ( 0x4A == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x72 ) ? 4 : 0 )                  \
	: ( 0x57 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )                  \
	: ( 0x66 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x73 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( 0x71 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x41 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( ( 0x73 == ((U8*)s)[2] ) && ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x67 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x46 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x63 == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) && ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xED == ((U8*)s)[0] ) && ( 0x70 == ((U8*)s)[1] ) ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x4A ) || ( 0x51 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x59 ) || ( 0x62 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x6A ) || ( ((U8*)s)[4] & 0xFC ) == 0x70 ) ) ? 5 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x81 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8F == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x8F == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x70 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAF == ((U8*)s)[2] ) && ( 0x62 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x62 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB4 == ((U8*)s)[2] ) ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( 0x67 == ((U8*)s)[1] || 0x68 == ((U8*)s)[1] ) ?                  \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x63 == ((U8*)s)[2] || 0x70 == ((U8*)s)[2] ) ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8F == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x8F == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x70 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAF == ((U8*)s)[2] ) && ( 0x62 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x62 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB4 == ((U8*)s)[2] ) ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xAB == ((U8*)s)[0] ) && ( 0x70 == ((U8*)s)[1] ) ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] || 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8F == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x8F == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x70 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB4 == ((U8*)s)[4] ) && ( 0x68 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x68 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAF == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB5 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAF == ((U8*)s)[2] ) && ( 0x62 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAF == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x62 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAF == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xB1 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB4 == ((U8*)s)[4] ) && ( 0x68 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB4 == ((U8*)s)[2] ) ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB8 == ((U8*)s)[0] ) ?                                             \
	( ( 0x52 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x46 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB8 == ((U8*)s)[3] ) && ( 0x53 == ((U8*)s)[4] ) ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x63 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB8 == ((U8*)s)[3] ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x46 == ((U8*)s)[5] || 0x52 == ((U8*)s)[5] || 0x54 == ((U8*)s)[5] || 0x65 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x72 == ((U8*)s)[2] ) && ( 0xB8 == ((U8*)s)[3] ) ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x65 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( 0x67 == ((U8*)s)[1] || 0x68 == ((U8*)s)[1] ) ?                  \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x63 == ((U8*)s)[2] || 0x70 == ((U8*)s)[2] ) ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x8A == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x73 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] || 0x9C == ((U8*)s)[0] || ( 0xB3 == ((U8*)s)[0] || 0xB4 == ((U8*)s)[0] ) ) ?\
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB8 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x53 == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x63 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x65 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || 0x72 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x69 == ((U8*)s)[1] ) ?                                             \
	( ( 0x57 == ((U8*)s)[2] || 0x59 == ((U8*)s)[2] || 0x63 == ((U8*)s)[2] || 0x65 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x70 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x71 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) || 0x59 == ((U8*)s)[2] || ( ((U8*)s)[2] & 0xFE ) == 0x62 || ( 0x65 == ((U8*)s)[2] || 0x66 == ((U8*)s)[2] ) || 0x70 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x53 || ((U8*)s)[2] == 0x59 || ( ( ((U8*)s)[2] & 0xFB ) == 0x62 ) || ((U8*)s)[2] == 0x65 ) ? 3 : 0 )\
    : ( ( 0x73 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x59 || ( ( ((U8*)s)[2] & 0xFE ) == 0x62 ) || ((U8*)s)[2] == 0x65 || ((U8*)s)[2] == 0x66 || ((U8*)s)[2] == 0x70 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x67 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x66 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0xAD ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x80 == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0x8A ) ?               \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( 0x8D == ((U8*)s)[0] || 0x9C == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x67 == ((U8*)s)[1] || 0x73 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xB3 == ((U8*)s)[0] || 0xB4 == ((U8*)s)[0] ) ?                          \
    ( ( 0x70 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( ( 0x65 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x67 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0xAD ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x80 == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0x8A ) ?               \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( 0x8D == ((U8*)s)[0] || 0x9C == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x67 == ((U8*)s)[1] || 0x73 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xAB == ((U8*)s)[0] || ( 0xB3 == ((U8*)s)[0] || 0xB4 == ((U8*)s)[0] ) ) ?\
    ( ( 0x70 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( ( 0x65 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x67 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((U8*)s)[0] & 0xEF ) == 0x05 ) || ((U8*)s)[0] == 0x0B || ( ( ((U8*)s)[0] & 0xFE ) == 0x0C ) || ((U8*)s)[0] == 0x25 || ((U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((U8*)s)[0] ) ) ? ( ( 0x41 == ((U8*)s)[1] ) ?\
		    ( ( 0x55 == ((U8*)s)[2] || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
		: ( ( 0x42 == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC 1047 */

#if 'A' == 193 /* EBCDIC 037 */ \
     && '\\' == 224 && '[' == 186 && ']' == 187 && '{' == 192 && '}' == 208 \
     && '^' == 176 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((U8*)s)[0] ) ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x56 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) ? ( ( 0x66 == ((U8*)s)[2] ) ?\
	    ( ( ( ( ((U8*)s)[3] & 0xF7 ) == 0x57 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x58 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x62 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) ) ? 4 : 0 )\
	: ( ( 0x67 == ((U8*)s)[2] || 0x68 == ((U8*)s)[2] ) && ( 0x42 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((U8*)s)[0] ) ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x70 == ((U8*)s)[3] ) ) ? 4 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( 0x55 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( 0x56 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( ( 0x72 == ((U8*)s)[2] ) && ( 0x71 == ((U8*)s)[3] || 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] || 0xEA == ((U8*)s)[0] || 0xEC == ((U8*)s)[0] ) ?   \
    ( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x71 == ((U8*)s)[3] || 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
: ( 0xED == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] == 0x4A || ((U8*)s)[1] == 0x52 || ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) || ((U8*)s)[1] == 0x58 || ((U8*)s)[1] == 0x5F || ((U8*)s)[1] == 0x63 || ( ( ((U8*)s)[1] & 0xFD ) == 0x65 ) || ((U8*)s)[1] == 0x69 || ( ( ((U8*)s)[1] & 0xFD ) == 0x70 ) ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) && ( 0x71 == ((U8*)s)[4] || 0x72 == ((U8*)s)[4] ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEE == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) && ( 0x71 == ((U8*)s)[4] || 0x72 == ((U8*)s)[4] ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0x64 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )

/*
	UTF8_CHAR: Matches legal UTF-EBCDIC encoded characters from 2 through 3 bytes

	0xA0 - 0x3FFF
*/
/*** GENERATED CODE ***/
#define is_UTF8_CHAR_utf8_no_length_checks(s)                               \
( ( 0x78 == ((U8*)s)[0] || 0x80 == ((U8*)s)[0] || ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x90 ) || ( 0x9A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xA0 ) || ( 0xAA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xAF ) || ( 0xB1 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xB5 ) ) ?\
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( ( ( ((U8*)s)[0] == 0xB7 || ( ( ((U8*)s)[0] & 0xFE ) == 0xB8 ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xBC ) || ( ( ((U8*)s)[0] & 0xEE ) == 0xCA ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xCC ) ) && ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part0(s)                                          \
( ( 0x51 == ((U8*)s)[1] ) ?                                                 \
	( ( 0x72 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part1(s)                                          \
( ( 0xBD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x62 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x70 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x62 ) ) ? 3 : 0 )\
: ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 == ((U8*)s)[1] ) && ( 0x52 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x55 ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] || ( 0x54 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFE ) == 0x70 ) ? 3 : 0 )\
    : ( 0x43 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x42 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x63 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x44 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
    : ( ( 0x53 == ((U8*)s)[1] ) && ( ( 0x57 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x43 ) || ( 0x49 == ((U8*)s)[1] || 0x4A == ((U8*)s)[1] ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x68 ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x69 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( ((U8*)s)[2] & 0xFE ) == 0x62 ) ? 3 : 0 )\
    : ( ( 0x6A == ((U8*)s)[1] ) && ( ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] & 0xF7 ) == 0x57 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x58 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) || ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] || 0x57 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x45 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( 0x4A == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x71 == ((U8*)s)[3] || 0x72 == ((U8*)s)[3] ) ? 4 : 0 )      \
	: ( 0x57 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )                  \
	: ( 0x65 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x72 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( 0x70 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x41 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( ( 0x72 == ((U8*)s)[2] ) && ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x66 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x46 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x62 == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) && ( 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x68 ) ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xED == ((U8*)s)[0] ) && ( 0x6A == ((U8*)s)[1] ) ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) && ( ( 0x41 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x4A ) || ( 0x51 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x59 ) || 0x5F == ((U8*)s)[4] || ( 0x62 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x6A ) || ( 0x70 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x72 ) ) ) ? 5 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xAF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x57 == ((U8*)s)[1] ) && ( 0x6A == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBC == ((U8*)s)[0] ) ? is_QUOTEMETA_high_part0(s) : is_QUOTEMETA_high_part1(s) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x81 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8E == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x8E == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x6A == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x65 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((U8*)s)[1] ) && ( 0xAF == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAD == ((U8*)s)[2] ) && ( 0x5F == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x5F == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x66 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || 0x6A == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8E == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x8E == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x6A == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x65 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((U8*)s)[1] ) && ( 0xAF == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAD == ((U8*)s)[2] ) && ( 0x5F == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x5F == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xAA == ((U8*)s)[0] ) && ( 0x6A == ((U8*)s)[1] ) ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] || 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8E == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x8E == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x6A == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x65 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x67 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x67 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAD == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xAF == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAD == ((U8*)s)[2] ) && ( 0x5F == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAD == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xAF == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x5F == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAD == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xAF == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x67 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB7 == ((U8*)s)[0] ) ?                                             \
	( ( 0x52 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x46 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x53 == ((U8*)s)[4] ) ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x62 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x46 == ((U8*)s)[5] || 0x52 == ((U8*)s)[5] || 0x54 == ((U8*)s)[5] || 0x64 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x71 == ((U8*)s)[2] ) && ( 0xB7 == ((U8*)s)[3] ) ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x64 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x66 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || 0x6A == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x80 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x72 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8C == ((U8*)s)[0] || 0x9B == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?\
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x53 == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x62 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x68 ) || 0x71 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x68 == ((U8*)s)[1] ) ?                                             \
	( ( 0x57 == ((U8*)s)[2] || 0x59 == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x6A == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x70 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) || 0x59 == ((U8*)s)[2] || 0x5F == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || ( ((U8*)s)[2] & 0xFE ) == 0x64 || 0x6A == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x71 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xDE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x53 || ((U8*)s)[2] == 0x59 || ((U8*)s)[2] == 0x5F ) ? 3 : 0 )\
    : ( ( 0x72 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xDE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x59 || ((U8*)s)[2] == 0x5F || ( ( ((U8*)s)[2] & 0xF7 ) == 0x62 ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x71 == ((U8*)s)[1] ) ) && ( 0x66 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x65 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xFC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x5C ) || ((U8*)s)[0] == 0x5E || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x6C ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ((U8*)s)[0] == 0xB0 || ( ( ((U8*)s)[0] & 0xFE ) == 0xBA ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x78 == ((U8*)s)[0] || 0x80 == ((U8*)s)[0] || 0x8A == ((U8*)s)[0] ) ?   \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( 0x8C == ((U8*)s)[0] || 0x9B == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x66 == ((U8*)s)[1] || 0x72 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?                                      \
    ( ( 0x6A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x68 ) || 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x71 == ((U8*)s)[1] ) ) && ( 0x66 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xFC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x5C ) || ((U8*)s)[0] == 0x5E || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x6C ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ((U8*)s)[0] == 0xB0 || ( ( ((U8*)s)[0] & 0xFE ) == 0xBA ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x78 == ((U8*)s)[0] || 0x80 == ((U8*)s)[0] || 0x8A == ((U8*)s)[0] ) ?   \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( 0x8C == ((U8*)s)[0] || 0x9B == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x66 == ((U8*)s)[1] || 0x72 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xAA == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?               \
    ( ( 0x6A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x68 ) || 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x71 == ((U8*)s)[1] ) ) && ( 0x66 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((U8*)s)[0] & 0xEF ) == 0x05 ) || ((U8*)s)[0] == 0x0B || ( ( ((U8*)s)[0] & 0xFE ) == 0x0C ) || ((U8*)s)[0] == 0x25 || ((U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((U8*)s)[0] ) ) ? ( ( 0x41 == ((U8*)s)[1] ) ?\
		    ( ( 0x55 == ((U8*)s)[2] || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
		: ( ( 0x42 == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC 037 */

#if 'A' == 193 /* EBCDIC POSIX-BC */ \
     && '\\' == 188 && '[' == 187 && ']' == 189 && '{' == 251 && '}' == 253 \
     && '^' == 106 && '~' == 255 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 74
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((U8*)s)[0] ) ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x57 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x75 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x75 == ((U8*)s)[1] ) ) ? ( ( 0x68 == ((U8*)s)[2] ) ?\
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) ) ? 4 : 0 )\
	: ( ( 0x69 == ((U8*)s)[2] || 0x70 == ((U8*)s)[2] ) && ( 0x42 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] || 0x57 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x75 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDC == ((U8*)s)[0] ) ) && ( 0x75 == ((U8*)s)[1] ) ) && ( 0x75 == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xDC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x75 == ((U8*)s)[1] ) ?                                             \
	( ( 0x56 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ? 4 : 0 )\
	: ( 0x57 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x57 ) ) ? 4 : 0 )\
	: ( ( 0x75 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x74 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDE == ((U8*)s)[0] || 0xE0 == ((U8*)s)[0] || 0xEA == ((U8*)s)[0] ) ?   \
    ( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x75 == ((U8*)s)[2] ) ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x74 ) ) ? 4 : 0 )\
: ( 0xEB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ( ( ((U8*)s)[1] & 0xF9 ) == 0x51 ) || ((U8*)s)[1] == 0x59 || ((U8*)s)[1] == 0x63 || ( ( ((U8*)s)[1] & 0xFD ) == 0x65 ) || ((U8*)s)[1] == 0x69 || ( ( ((U8*)s)[1] & 0xFD ) == 0x71 ) || ((U8*)s)[1] == 0x75 ) && ( 0x75 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x74 ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEC == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x75 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x74 ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0x66 ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) && ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ) ? 4 : 0 )

/*
	UTF8_CHAR: Matches legal UTF-EBCDIC encoded characters from 2 through 3 bytes

	0xA0 - 0x3FFF
*/
/*** GENERATED CODE ***/
#define is_UTF8_CHAR_utf8_no_length_checks(s)                               \
( ( ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x90 ) || ( 0x9A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xA1 ) || ( 0xAA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xB5 ) ) ?\
    ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ? 2 : 0 )\
: ( ( ( ( 0xB7 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xBA ) || ( 0xBE <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xC0 ) || ( 0xCA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xD0 ) || 0xDA == ((U8*)s)[0] ) && ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part0(s)                                          \
( ( 0x64 == ((U8*)s)[1] ) ?                                                 \
	( ( 0x41 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x73 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x64 ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part1(s)                                          \
( ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 == ((U8*)s)[1] ) && ( 0x53 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] || ( 0x55 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x69 ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x75 ) ) ?\
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x74 ) ) ? 3 : 0 )\
    : ( 0x43 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ((U8*)s)[2] == 0x51 || ((U8*)s)[2] == 0x65 || ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x44 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x57 ) ) ? 3 : 0 )\
    : ( ( 0x54 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x75 ) ) ) ? 3 : 0 )\
: ( 0xCB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x43 ) || 0x49 == ((U8*)s)[1] || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x69 ) || 0x70 == ((U8*)s)[1] || ( 0x73 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x75 ) ) ?\
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x71 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x65 ) ) ? 3 : 0 )\
    : ( ( 0x72 == ((U8*)s)[1] ) && ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x75 ) ) ) ? 3 : 0 )\
: ( 0xCC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ((U8*)s)[1] & 0xFE ) == 0x58 || ( ((U8*)s)[1] & 0xFE ) == 0x62 ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xE7 ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ((U8*)s)[2] == 0x44 || ( ( ((U8*)s)[2] & 0xFC ) == 0x54 ) || ((U8*)s)[2] == 0x58 || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] || 0x58 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( ( 0x53 == ((U8*)s)[1] ) && ( 0x45 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xDC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x75 == ((U8*)s)[1] ) ?                                             \
	( ( 0x51 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x74 ) ? 4 : 0 )                  \
	: ( 0x58 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x57 ) ) ? 4 : 0 )\
	: ( 0x62 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )                  \
	: ( 0x67 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x75 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( 0x73 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x41 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( ( 0x75 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x68 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x57 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x46 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x64 == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) && ( ( 0x63 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || 0x70 == ((U8*)s)[3] ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xEB == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) ) && ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ) && ( ( ( ((U8*)s)[4] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[4] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[4] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[4] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[4] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[4] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[4] & 0xFA ) == 0x70 ) ) ) ? 5 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xB0 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x58 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x52 == ((U8*)s)[1] ) ?                                             \
	( ( 0x75 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x53 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBE == ((U8*)s)[0] ) ? is_QUOTEMETA_high_part0(s) : is_QUOTEMETA_high_part1(s) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x81 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x90 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x90 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) ?                              \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[1] || 0x67 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x69 == ((U8*)s)[1] ) && ( 0xB0 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAE == ((U8*)s)[2] ) && ( 0x63 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x63 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x51 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x56 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xC0 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x71 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x58 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] || 0x72 == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x90 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x90 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) ?                              \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[1] || 0x67 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x69 == ((U8*)s)[1] ) && ( 0xB0 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAE == ((U8*)s)[2] ) && ( 0x63 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x63 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x51 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x56 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xAB == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] || 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x90 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x90 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) ?                              \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[1] || 0x67 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x69 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x69 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAE == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB0 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAE == ((U8*)s)[2] ) && ( 0x63 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAE == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB0 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x63 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAE == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xB0 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x51 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x69 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x56 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB7 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x46 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x54 == ((U8*)s)[4] ) ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x64 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x53 == ((U8*)s)[4] ) ) && ( ( ( ((U8*)s)[5] & 0xDF ) == 0x46 ) || ((U8*)s)[5] == 0x53 || ((U8*)s)[5] == 0x55 ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x74 == ((U8*)s)[2] ) && ( 0xB7 == ((U8*)s)[3] ) ) && ( 0x53 == ((U8*)s)[4] ) ) && ( 0x66 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xC0 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x71 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x58 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] || 0x72 == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x8B == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x75 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] || 0x9D == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?\
    ( ( 0x58 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x54 == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xC0 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x64 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x70 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] == 0x58 || ((U8*)s)[2] == 0x62 || ( ( ((U8*)s)[2] & 0xFD ) == 0x64 ) ) ? 3 : 0 )\
    : ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x73 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x62 ) || ((U8*)s)[2] == 0x64 || ((U8*)s)[2] == 0x72 ) ? 3 : 0 )\
    : ( 0x74 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x54 || ( ( ((U8*)s)[2] & 0xFA ) == 0x62 ) ) ? 3 : 0 )\
    : ( ( 0x75 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ( ( ((U8*)s)[2] & 0xFA ) == 0x62 ) || ((U8*)s)[2] == 0x64 || ((U8*)s)[2] == 0x72 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x74 == ((U8*)s)[1] ) ) && ( 0x68 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || ( 0x63 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x67 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0x4A ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xAF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xBF ) == 0xBB ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xBC ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC2 ) || ( ( ((U8*)s)[0] & 0xCC ) == 0xC4 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xF0 ) || ( ( ((U8*)s)[0] & 0xFD ) == 0xFD ) ) ? 1\
: ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x8C ) ?                          \
    ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ? 2 : 0 )\
: ( 0x8E == ((U8*)s)[0] || 0x9D == ((U8*)s)[0] ) ?                          \
    ( ( 0x58 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x90 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x68 == ((U8*)s)[1] || 0x75 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?                                      \
    ( ( 0x72 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC0 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x51 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x52 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x74 == ((U8*)s)[1] ) ) && ( 0x68 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0x4A ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xAF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xBF ) == 0xBB ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xBC ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC2 ) || ( ( ((U8*)s)[0] & 0xCC ) == 0xC4 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xF0 ) || ( ( ((U8*)s)[0] & 0xFD ) == 0xFD ) ) ? 1\
: ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x8C ) ?                          \
    ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ? 2 : 0 )\
: ( 0x8E == ((U8*)s)[0] || 0x9D == ((U8*)s)[0] ) ?                          \
    ( ( 0x58 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x90 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x68 == ((U8*)s)[1] || 0x75 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xAB == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?               \
    ( ( 0x72 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC0 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x51 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x52 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x74 == ((U8*)s)[1] ) ) && ( 0x68 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((U8*)s)[0] & 0xEF ) == 0x05 ) || ((U8*)s)[0] == 0x0B || ( ( ((U8*)s)[0] & 0xFE ) == 0x0C ) || ((U8*)s)[0] == 0x25 || ((U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((U8*)s)[0] ) ) ? ( ( 0x41 == ((U8*)s)[1] ) ?\
		    ( ( ( ((U8*)s)[2] & 0xFE ) == 0x56 ) ? 3 : 0 )          \
		: ( ( 0x42 == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC POSIX-BC */

#endif /* H_REGCHARCLASS */

/* Generated from:
 * 083180df694deb1fc173361406c1a75619fb8376403db3a76dc585c1e3951eca lib/Unicode/UCD.pm
 * 827aa7ee45ca9fe09f3e0969a5a27a69ce58a6c7134548125266210018d27b49 lib/unicore/ArabicShaping.txt
 * 3748fbbe9d280a9da700bfd0c28beaaf6f32a67ec263a124fcb0a4095a30fae5 lib/unicore/BidiBrackets.txt
 * 3925329c2432fa7248b2e180cddcedb9a4f9eafbbb10ab9e105eaf833043b2fb lib/unicore/BidiMirroring.txt
 * 7f5a1b4a346c6cdbe948d3baf50fc31fff29c26bcd4ad422dc1fbcc1c23b0bde lib/unicore/Blocks.txt
 * 82f3cc8217455f22d294d7df767a62906baf31456ea8902336ae7fee943a2538 lib/unicore/CaseFolding.txt
 * 8be553529f7dd22e3e0ffa25eb3f1743f5243bbfe868559be73bf3a163c21913 lib/unicore/CompositionExclusions.txt
 * ab64278818411762311b9d5974438ac5cf14e98c79b44a6373022f0780de38a7 lib/unicore/DAge.txt
 * f2ff892add5e6624cee8300c297373216df7f1a596c6e74510afe5e8b96c8d91 lib/unicore/DCoreProperties.txt
 * 656aa2c6996a049e84c6d38676bc73c3245c808869d64073b812690ae475d534 lib/unicore/DNormalizationProps.txt
 * e064b066e555cbace95951fcba9b5336a4d04c88c5949a1ff7615190eaa67682 lib/unicore/EastAsianWidth.txt
 * 2aa574984e9cea6980eddd6e36044168d543b7f0449266fa3248aca28790cf06 lib/unicore/HangulSyllableType.txt
 * e7122c4d4d598854b5fbefeb2b1ee9f05aef6a8d6e718b5f56c2a8ea31145f12 lib/unicore/IndicMatraCategory.txt
 * 478ca00ea86b47209f0b27eb3959ad83cb2b76f5159213d242390d07d5af2b8d lib/unicore/IndicSyllabicCategory.txt
 * 0aa8af5cbb4d0570b1006aefffc021c6ef637dffb15572a5a85e7f7e7778fe22 lib/unicore/Jamo.txt
 * 3b359eeff325f7e773ea9d5feb8af053b94c579844f0db7ce648f418c9d136d8 lib/unicore/LineBreak.txt
 * af85d961d0ed6055271ca6e0174451a8dc1822e31de9e07e1246535318b9341a lib/unicore/NameAliases.txt
 * 1c379b9c1b0f6cd14208b766f74fc92ff5a9528aee66083db307f1fc9a615729 lib/unicore/NamedSequences.txt
 * 0df343d93293f14e9ff0b0a721d8b8e6c23c86dbad7be18d362d6bf1281590d9 lib/unicore/PropList.txt
 * 6c14f474761b8db46f95cf2d1e235ce40abf3382226c5b1a2210df83775fe6fa lib/unicore/PropValueAliases.txt
 * 3f3dd77644faa905ce02de7c0e3167fdc4afdf94748f074192bd70821c8341ea lib/unicore/PropertyAliases.txt
 * 2767531dec8c525a317ab488b95eed73461fe9c6fbb8088594f3886964724475 lib/unicore/ScriptExtensions.txt
 * a638f9f0eb3c521ed6c7755fce93c04bf6e4ba89f23ac3d1bd4c4e486c400118 lib/unicore/Scripts.txt
 * 35496d45fc8babd8deb866491ea82ff7b3d2d49ad4c9c656685cd14833101e25 lib/unicore/SpecialCasing.txt
 * bfa3da58ea982199829e1107ac5a9a544b83100470a2d0cc28fb50ec234cb840 lib/unicore/UnicodeData.txt
 * 916289f471c4a337fb1e0715985a11e6bc8bb205736e84164849d601d265d9e0 lib/unicore/auxiliary/GCBTest.txt
 * 3d7ffae56e506d595f3e0e5d36978bc6721d53470e5ca9666ad7cdfc4a46cb3d lib/unicore/auxiliary/GraphemeBreakProperty.txt
 * 370ddf3ba9b337819cf21795c2bd7cda578ac5ff4700d1a3ac923e8be988b57e lib/unicore/auxiliary/SBTest.txt
 * 28356f6912113a9fe8244d9396e9786115dbc10b3ffb5e31b08969122e91d3f3 lib/unicore/auxiliary/SentenceBreakProperty.txt
 * 3f56d3ccfc35c6dac44d143a4d6087af4e4ee9f1bdbae482c12f6149b60dec3b lib/unicore/auxiliary/WBTest.txt
 * 82f7304030e6866ef8e02cdfb0485c52c18a661282bfce9c259cc6300abd79ad lib/unicore/auxiliary/WordBreakProperty.txt
 * b88801b4a469207892a0401697c6b1c5fd64042ae0ef867f4ad0ec04942b415c lib/unicore/extracted/DBidiClass.txt
 * 074d33ea6c7349eab840d690369dffb3568e2f7b039552b7c10480274d321545 lib/unicore/extracted/DBinaryProperties.txt
 * 8ad457aef3525aedce823b9177dad33e0088df536dff11e3df405ecefc92ba08 lib/unicore/extracted/DCombiningClass.txt
 * 59ec46c1e30458ffff50d41196fd45e3bbaf3172a8111117af1b930199be2d96 lib/unicore/extracted/DDecompositionType.txt
 * cf7c07557ae915a7508c6c7fc8c2e8c900782364ec62e8a5d2813f3b97449ee0 lib/unicore/extracted/DEastAsianWidth.txt
 * 56a5b47331a7ec784e848bcaae1ddc08cbf72aab583ca82dcc98ecf2851a3d43 lib/unicore/extracted/DGeneralCategory.txt
 * c14e83161e56eb15d78b1589352d6c0bd8feb7889a5d17f70a2ebb2a43cab86d lib/unicore/extracted/DJoinGroup.txt
 * 8c9405c54d8b1dd3fe2f2d691b30c0816ca15481995152ed07fc9b844dfd0ad4 lib/unicore/extracted/DJoinType.txt
 * a9791f08281d7b0a417e4ad882cf64463f6815db8156932acd85228ac717fd94 lib/unicore/extracted/DLineBreak.txt
 * a17a0330e57d774343a53c019f1bc69827c2676982a1bf48e0898a76710e8877 lib/unicore/extracted/DNumType.txt
 * c2cb810a67cc5fb4a8d236b6c1bc6dd4d89733d8603881997e8aae2c816a3db1 lib/unicore/extracted/DNumValues.txt
 * 808d76136d9952faf581347e9bc040dbab5158f143f243a6de455a4af39b7401 lib/unicore/mktables
 * 746472de66b936ac885ca6d6e68058242b4e909e3260c6317f3ec719f78f76cc lib/unicore/version
 * 3eaedce3745bef6219cff3b5f63e5f8622c58dc66736281a82df991636d54451 regen/regcharclass.pl
 * ex: set ro: */
