/* PacketHandler.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "labrea.h"
#include "KOTB.c"
#include "IPHandler.c"

void PacketHandler(u_char* client_data, const struct pcap_pkthdr* pcpkt, const u_char* pktdata) {
  /* externs */
  extern u_char *exclusion, *sha;
  extern char mybuffer[], format8[], format9[], *dev, strlf[];
  extern char format6[], format10[], str17[], str18[];
  extern struct kotb *nkotbstart;
  extern int dlsize, xflag, qflag, sflag, hflag, rate, datalog;
  extern bpf_u_int32 myip, base;  
  extern u_int addresses, *addr_array, nkotbcount;
  extern time_t *time_array;
  extern struct libnet_link_int *plnk;
  extern int oflag, Oflag;
  /* locals */
  int i;
  char tnow[60];
  u_char *link = (u_char *)pktdata, *ptr = ((u_char*)link) + dlsize;
  u_int spa, tpa, inettpa, inetspa, offset;
  u_short usType;
  struct kotb *newkid, *p = nkotbstart, *t;
  time_t current = 0, addrtime;
  u_char bogusMAC[6] = {0,0,15,255,255,255};
  u_char bcastMAC[6] = {255,255,255,255,255,255};

  /* what type of packet is this? - ETHERNET SPECIFIC */
  usType = ntohs(*(u_short*)(link+12));
  /* packet type: 0x800 = IP */
  if(usType == 0x800) {
    IPHandler(client_data, pcpkt, link);
    return;
  }
  /* if it isn't an ARP packet */
  /* or if IP capture is disabled */
  /* or if it's a non-IP arp - return */
  if((usType != 0x806) || (xflag) || (ntohs(*(u_short*)(ptr+2)) != 0x800))
    return;
  /* grab the ARP "operation type" */
  usType = ntohs(*((u_short*)(ptr+6)));
  /* source IP */
  inetspa = *((bpf_u_int32*)(ptr+14));
  spa = ntohl(inetspa);
  /* target IP */
  inettpa = *((bpf_u_int32*)(ptr+24));
  tpa = ntohl(inettpa);
  switch(usType) {
    /* Handle an ARP_REQUEST */
    case ARP_REQUEST:
      /* ignore our own arps */
      if(inetspa == myip)
        return;
      /* calculate our offset from "base" of available local IPs */
      offset =  tpa - base;
      /* goofy IP address - don't touch it, and (if we're */
      /* supposed to) tell someone that we saw it         */
      if((offset < 0) || (offset > addresses)) {
        if(qflag == 0) {
          sprintf(mybuffer, format10,
                  ((tpa & 0xFF000000) >> 24),((tpa & 0xFF0000) >> 16),((tpa & 0xFF00) >> 8),(tpa & 0xFF),
                  ((spa & 0xFF000000) >> 24),((spa & 0xFF0000) >> 16),((spa & 0xFF00) >> 8),(spa & 0xFF));
          goto logprint;
        }
        return;
      }
      /* handle exclusions */
      if(exclusion[offset] == IP_EXCLUDE)
        return;
      current = time(NULL);
      /* Gratuitous ARP */
      /* added spa = 0 for the Macs... they do a wacky gratuitous arp */
      /* arp who-has 192.168.0.1 tell 0.0.0.0 - Why... why... WHY???  */
      if((spa == tpa) || (spa == 0)) {
        /* if we see a gratuitous arp, we want to    */
        /* attempt to gracefully step out of the way */
        /* even if we've "hard" captured this...     */
        /* reset everything in our arrays            */
        time_array[offset] = 0;
        exclusion[offset] = IP_NOTHING;
        addr_array[offset] = 0;
        /*              NEW KIDS ON THE BLOCK                */
        /* We're going to make a list of anyone who pops     */
        /* up new, using a gratuitous arp to announce their  */
        /* presence.  We hang onto this information for some */
        /* time, and then route anything that comes through  */
        /* to the correct place.  Hopefully this will help   */
        /* keep us from really screwing things up...         */
        /* A new kid on the block... add it to our list...   */
        /* but first, check to see if it's there already     */
        if(nkotbcount > 0) {
          while(p != NULL) {
            if(p->ip == inettpa) {
              /* this is another gratuitous arp for an  */
              /* IP that we're already keeping track of */
              /* so we simply bump the culltime...      */
              p->time = current + CULLTIME;
              return;
            }
            p = p->next;
          }
        }
        /* if we're here, it wasn't on the list...  */
        /* so, we're going to put it there...       */
        newkid = allocNKOTB();
        /* set up a time to cull this from the list */
        newkid->time = current + CULLTIME;
        /* copy the IP of the new kid */
        newkid->ip = inettpa;
        /* ... and their MAC */
        for(i = 0; i < 6; i++)
          newkid->mac[i] = link[i+6];
        /* and we're done... */
        return;
      }
      /* if we get here, we know the following:  */
      /* the IP isn't excluded...                */
      /* this isn't a gratuitous arp...          */
      /* this isn't a wacky IP...                */
      /* this isn't one of our own arps...       */
      /* so...                                   */
      /* if we've already hard captured it, it's */
      /* ours... otherwise, check to see if we   */
      /* should capture this IP address...       */
      if(exclusion[offset] != IP_HARDCAPTURED) {
        /* pull the stored time out of the array */
        addrtime = time_array[offset];
        /* if this arp request came from someone new...     */
        /* or if it's been more than MAXARPTIME, start over */
        if((addr_array[offset] != spa) || (addrtime + MAXARPTIME <= current))
          addrtime = 0;
        /* if the stored time is 0, we're starting fresh...    */
        /* store the current time so we know when the arp hit. */
        /* this will happen on the first arp, when we timeout, */
        /* or when we get another arp request for the same IP  */
        /* but from a different source...                      */
        if(addrtime == 0) {
          /* store current time and arp source */
          time_array[offset] = current;
          addr_array[offset] = spa;
          /* if we're in a switched environment */
          /* we need to send an arp of our own  */
          goto arpsend;
        }
        /* if there is a time stored, but we haven't timed out, leave */
        if((addrtime + rate) > current)
          /* if we're in a switched environment */
          /* we need to send an arp of our own  */
          goto arpsend;
      }
      /* If we're here, we've timed out, or we've hard captured this IP already... */
      /* in either case, we need to send out an arp reply, to route any traffic to */
      /* this IP address to our bogus ARP address... creating a virtual machine... */
      /* If we're hard capturing, and this address isn't hard excluded, we want to */
      /* hard capture it...                                                        */
      if((hflag) && (exclusion[offset] < IP_HARDEXCLUDE))
        exclusion[offset] = IP_HARDCAPTURED;
      /* Check if this IP is on our "new kids" list.. if it is, remove it... Why?    */
      /* Well, since we're here, whatever sent out the gratuitous arp that got this  */
      /* IP listed as a "new kid" isn't answering arp requests... so we'll re-take   */
      /* the IP and kick if off the "new kids" list. Whatever wanted this IP, didn't */
      /* want it very bad... or else, has left the scene...                          */
      if(nkotbcount > 0) {
        while(p != NULL) {
          if(p->ip == inettpa) {
            t = p;
            killNKOTB(t);
            p = NULL;
          } else
            p = p->next;
        }
      }
      /* back to zero to start over...*/
      time_array[offset] = 0;
      addr_array[offset] = 0;
      /* let's build us an arp packet... right over top of the original */
      /* ETHERNET SPECIFIC */
      for(i = 0; i < 6; i++) {
        /* move the source MAC to destination MAC in the ether header */
        link[i] = link[i+6];
        if(sflag)
          /* stuff the Bogus MAC in as the source */
          /* in a switched environment... to give */
          /* the switch a clue where the MAC is...*/
          link[i+6] = bogusMAC[i];
        else
          /* stuff our MAC in as the source */
          link[i+6] = sha[i];
        /* stuff our bogus MAC into the Target MAC */
        ptr[i+18] = bogusMAC[i];
      }
      /* change op -> arp reply */
      ptr[7] = 2;
      /* swap sender/target */
      for(i = 8; i < 18; i++)
        SWAP(ptr[i], ptr[i + 10]);
      /* we've made it... now, let's send it */
      /* "All your IP are belong to us!" ;-) */
      libnet_write_link_layer(plnk, dev, link, 28 + dlsize);
      if(datalog > 1) {
        /* tell 'em what we're doing */
        sprintf(mybuffer, format6, str17,
                ((tpa & 0xFF000000) >> 24),((tpa & 0xFF0000) >> 16),((tpa & 0xFF00) >> 8),(tpa & 0xFF));
        goto logprint;
      }
      break;
    case ARP_REPLY:
      /* someone replied... knock down the time */
      offset = spa - base;
      /* goofy IP address - don't touch it, and (if we're supposed to), tell someone */
      if((offset < 0) || (offset > addresses)) {
        if(qflag == 0) {
          sprintf(mybuffer, format6, str18,
                  ((spa & 0xFF000000) >> 24),((spa & 0xFF0000) >> 16),((spa & 0xFF00) >> 8),(spa & 0xFF));
          goto logprint;
        }
        return;
      }
      time_array[offset] = 0;
      addr_array[offset] = 0;
      break;
  }
  return;
  logprint:
  /* here, we print a message to STDOUT, with the    */
  /* timestamp in one of two formats, or we send it  */
  /* to syslog, and then return from PacketHandler() */
  if(oflag) {
    if(Oflag)
      printf(format8, current, mybuffer);
    else {
      strncpy(tnow, ctime(&current),50);
      strtok(tnow, strlf) ;
      printf(format9, tnow, mybuffer);
    }
  } else
    syslog(LOGTYPE, mybuffer);
  return;
  arpsend:
  if(sflag) {
    /* here we send out an arp request of our own (if   */
    /* we're in a switched environment) and return from */
    /* the PacketHandler() function...                  */
    for(i = 0; i < 6; i++) {
      /* move the broadcast MAC into the     */
      /* destination MAC in the ether header */
      link[i] = bcastMAC[i];
      /* stuff our MAC in as the source */
      /* in both the link layer and the arp */
      link[i+6] = sha[i];
      ptr[i+8] = sha[i];
    }
    /* drop our IP in as the sender */
    *(u_int*)(ptr + 14) = myip;
    /* we made it... now, send it! */
    libnet_write_link_layer(plnk, dev, link, 28 + dlsize);
  }
}
