/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public class DocAvailable
extends SystemFunction {
    private String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        if (hrefVal == null) {
            return BooleanValue.FALSE;
        }
        String href = hrefVal.getStringValue();
        Controller controller = context.getController();
        ErrorListener old = controller.getErrorListener();
        controller.setErrorListener(ErrorDiscarder.THE_INSTANCE);
        boolean b = this.docAvailable(href, context);
        controller.setErrorListener(old);
        return BooleanValue.get(b);
    }

    public boolean docAvailable(String href, XPathContext context) throws XPathException {
        try {
            DocumentURI documentKey = DocumentFn.computeDocumentKey(href, this.expressionBaseURI, context);
            DocumentPool pool = context.getController().getDocumentPool();
            if (pool.isMarkedUnavailable(documentKey)) {
                return false;
            }
            DocumentInfo doc = pool.find(documentKey);
            if (doc != null) {
                return true;
            }
            NodeInfo item = DocumentFn.makeDoc(href, this.expressionBaseURI, context, this);
            if (item != null) {
                return true;
            }
            pool.markUnavailable(documentKey);
            return false;
        }
        catch (XPathException e) {
            return false;
        }
    }

    public static class ErrorDiscarder
    implements ErrorListener {
        public static ErrorDiscarder THE_INSTANCE = new ErrorDiscarder();

        public void warning(TransformerException exception) {
        }

        public void error(TransformerException exception) {
        }

        public void fatalError(TransformerException exception) {
        }
    }
}

