/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.Message;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public final class XSLMessage
extends StyleElement {
    private Expression terminate = null;
    private Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String terminateAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("terminate")) {
                terminateAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        if (terminateAtt == null) {
            terminateAtt = "no";
        }
        this.checkAttributeValue("terminate", terminateAtt, true, StyleElement.YES_NO);
        this.terminate = this.makeAttributeValueTemplate(terminateAtt);
    }

    public void validate(Declaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        this.terminate = this.typeCheck("terminate", this.terminate);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        Expression b = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (b != null) {
            if (this.select == null) {
                this.select = b;
            } else {
                this.select = Block.makeBlock(this.select, b);
                this.select.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (this.select == null) {
            this.select = new StringLiteral("xsl:message (no content)");
        }
        return new Message(this.select, this.terminate);
    }
}

