# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

App::Greple::xlate is a Perl module that provides translation support for the greple text processor. It enables translation of text using various AI-powered services including DeepL, GPT-3.5, GPT-4, and GPT-4o engines.

## Build and Development Commands

This is a Perl module built using Minilla and Module::Build::Tiny:

```bash
# Install dependencies
cpanm --installdeps .

# Build the module
perl Build.PL
./Build

# Run tests
./Build test
# Or run specific tests:
prove -lv t/00_compile.t
prove -lv t/01_unit.t
prove -lv t/02_run.t

# Install locally
./Build install

# Clean build artifacts
./Build clean
```

## Project Architecture

### Core Module Structure
- `lib/App/Greple/xlate.pm` - Main module with translation logic
- `lib/App/Greple/xlate/` - Translation engine implementations:
  - `deepl.pm` - DeepL API integration
  - `gpt3.pm` - GPT-3.5 integration  
  - `gpt4.pm` - GPT-4 integration
  - `gpt4o.pm` - GPT-4o integration
  - Supporting modules: `Cache.pm`, `Filter.pm`, `Lang.pm`, `Mask.pm`, `Text.pm`

### Command Line Interface
- `script/xlate` - Main CLI command
- `share/xlate.el` - Emacs integration
- `share/XLATE.mk` - Makefile for translation workflows

### Translation Workflow
The module works by:
1. Finding text patterns using greple's pattern matching
2. Extracting text blocks for translation
3. Caching translations to avoid redundant API calls
4. Supporting multiple output formats (conflict markers, ifdef, etc.)
5. Providing various masking and filtering options

### Key Features
- Multiple translation engines (DeepL, OpenAI GPT variants)
- Caching system for translations
- Pattern-based text extraction
- Multiple output formats
- Docker integration
- Emacs editor integration

## Translation Cache Files
The system generates `.json` cache files alongside source files to store translations and avoid redundant API calls. These follow the pattern `filename.xlate-{engine}-{language}.json`.

## Environment Variables
- `DEEPL_AUTH_KEY` - DeepL API authentication
- `OPENAI_API_KEY` - OpenAI API authentication
- `XLATE_DEBUG` - Enable debug output
- `XLATE_MAXLEN` - Set maximum API call length
- `XLATE_USEAPI` - Use API mode
- `XLATE_UPDATE` - Force cache updates

## Examples and Documentation
- `examples/` - Contains sample translation workflows with various file formats
- `docs/` - Multi-language documentation generated from the main POD
- Multiple README files in different languages generated by the translation system itself

## Critical File Handling Requirements
- **ALWAYS ensure ALL files end with a newline character** when using Write, Edit, or MultiEdit tools
- This is mandatory for proper file handling and to avoid issues with text processing tools, git, and other utilities
- Before finalizing any file operation, verify the content ends with '\n'

## Important Behavior Guidelines
- **警告やエラーを無視しない**: git statusの警告、テストの失敗、Dockerのエラーなど、問題が発生したら「外部の問題」「関係ない」と推測で片付けずに、必ず原因を調査する
- **推測で判断しない**: 「〜だろう」「〜のはず」で済ませず、実際に確認してから判断する
- **問題から逃げない**: 面倒そうに見えても、根本原因を特定して適切に修正する
